@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Client::client.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Client::client.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('client.list') }}"><i class="fa fa-laptop"></i>{{ trans('Client::client.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Client::client.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    @permission('admin@user-add')
                    <a href="{{ route('client.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Client::client.buttons.create') }}
                        </button>
                    </a>
                    @endpermission
                    <div id="hide-table">
                        <table id="clients-table" class="table table-striped table-bordered table-hover no-footer">
                            <thead>
                            <tr>
                                <th><input type="checkbox" class="btn" id="bulkDelete"/> <button class="btn btn-xs btn-primary" id="deleteTriger">Delete</button></th>
                                {{--<th>Photo</th>--}}
                                <th data-title="{{ trans('Iauth::user.columns.photo') }}">{{ trans('Iauth::user.columns.photo') }}</th>
                                <th data-title="{{ trans('Client::client.columns.company') }}">{{ trans('Client::client.columns.company') }}</th>
                                <th data-title="{{ trans('Iauth::user.columns.fullname') }}">{{ trans('Iauth::user.columns.fullname') }}</th>
                                <th data-title="{{ trans('Iauth::user.columns.username') }}">{{ trans('Iauth::user.columns.username') }}</th>
                                <th data-title="{{ trans('Iauth::user.columns.email') }}">{{ trans('Iauth::user.columns.email') }}</th>
                                <th data-title="{{ trans('Iauth::user.columns.action') }}">{{ trans('Iauth::user.columns.action') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>
@endsection


@push('footerAssetPush')
<script type="application/javascript">
    $(function() {
        var t = $('#clients-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: false,
            ajax: '{{ route("client.list.datatable") }}',
//            dom: 'lBfrtip',
            buttons: [
                {
                    extend: 'collection',
                    text: 'Export',
                    buttons: [
                        'copy',
                        'excel',
                        'csv',
                        'pdf',
                        'print'
                    ]
                }
            ],
            columns: [
                {data: function(data){
                    return '<input type="checkbox" class="btn deleteRow" name="id[]" value="'+ data.id +'" />';
                }, orderable: false, searchable:false, name:"id" },
                {data: 'photo', name: 'photo', className: "text-center"},
                {data: 'company', name: 'company'},
                {data: 'name', name: 'name', className: 'text-center'},
                {data: 'username', name: 'username'},
                {data: 'email', name: 'email'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            createdRow: function( row, data, dataIndex ) {
                $( row ).find('td:eq(0)').attr('data-title', '#');
                $( row ).find('td:eq(1)').attr('data-title', '{{ trans('Iauth::user.columns.photo') }}');
                $( row ).find('td:eq(2)').attr('data-title', '{{ trans('Client::client.columns.company') }}');
                $( row ).find('td:eq(3)').attr('data-title', '{{ trans('Iauth::user.columns.fullname') }}');
                $( row ).find('td:eq(4)').attr('data-title', '{{ trans('Iauth::user.columns.username') }}');
                $( row ).find('td:eq(5)').attr('data-title', '{{ trans('Iauth::user.columns.email') }}');
                $( row ).find('td:eq(6)').attr('data-title', '{{ trans('Iauth::user.columns.action') }}');
            }
        });

        $("#bulkDelete").on('click',function() { // bulk checked
            var status = this.checked;
            $(".deleteRow").each( function() {
                $(this).prop("checked",status);
            });
        });

        $('#deleteTriger').on("click", function(event){ // triggering delete one by one
            @if(!config('core.demosite'))
                if( $('.deleteRow:checked').length > 0 ){  // at-least one checkbox checked
                    var ids = [];
                    $('.deleteRow').each(function(){
                        if($(this).is(':checked')) {
                            ids.push($(this).val());
                        }
                    });
                    var ids_string = ids.toString();  // array to string conversion
                    $.ajax({
                        type: "POST",
                        url: "{{ route("user.multi.delete") }}",
                        data: {ids:ids_string},
                        success: function(result) {
                            t.draw(); // redrawing datatable
                        },
                        async:false
                    });
                }
            @else
                alert("Bulk Delete option is Disable only for Demo.");
            @endif

        });

//		t.on( 'order.dt search.dt', function () {
//			t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
//				cell.innerHTML = i+1;
//			} );
//		} ).draw();
    });
</script>
@endpush