@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Client::client.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Client::client.optional_title.view') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('client.list') }}"><i class="fa fa-laptop"></i>{{ trans('Client::client.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Client::client.breadcrumb.second') }}</li>
@endsection


@section('moduleContent')
    <div class="row">
        <!-- Left col -->
        <div class="col-md-4">
            <!-- Widget: user widget style 1 -->
            <div class="box box-widget widget-user-2">
                <!-- Add the bg color to the header using any of the bg-* classes -->
                <div class="widget-user-header bg-maroon" style="height: auto;">
                    <div class="widget-user-image">
                        <img class="img-circle" src="{{ url($user->img) }}" alt="User Avatar">
                    </div>
                    <!-- /.widget-user-image -->
                    <h3 class="widget-user-username">
                        @if($user->name==null)
                            {{ $user->username  }}
                        @else
                            {{ $user->name  }}
                        @endif
                    </h3>
                    <h5 class="widget-user-desc">{{ $user->username  }}</h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked">
                        <li><a href="#"><b>{{ trans("Iauth::user.profile-title") }}</b></a></li>
                        <li><a href="#">{{ trans("Iauth::user.columns.email") }} <span class="pull-right badge bg-blue">{{ $user->email }}</span></a></li>
                        @if(isset($client))
                            <li><a href="#">{{ trans('Client::client.columns.company') }} <span class="pull-right badge bg-yellow">{{ $client->company }}</span></a></li>
                            <li><a href="#">{{ trans('Client::client.columns.phone') }} <span class="pull-right badge bg-maroon">{{ $client->phone }}</span></a></li>
                            <li><a href="#">{{ trans('Client::client.columns.address_line_one') }} <span class="pull-right badge bg-white">{{ $client->address_line_one }}</span></a></li>
                            <li><a href="#">{{ trans('Client::client.columns.address_line_two') }} <span class="pull-right badge bg-black">{{ $client->address_line_two }}</span></a></li>
                            <li><a href="#">{{ trans('Client::client.columns.city') }} <span class="pull-right badge bg-blue">{{ $client->city }}</span></a></li>
                            <li><a href="#">{{ trans('Client::client.columns.zip_code') }} <span class="pull-right badge bg-purple">{{ $client->zip_code }}</span></a></li>
                            <li><a href="#">{{ trans('Client::client.columns.state') }} <span class="pull-right badge bg-red">{{ $client->state }}</span></a></li>
                            <li><a href="#">{{ trans('Client::client.columns.country') }} <span class="pull-right badge bg-yellow">{{ $client->country }}</span></a></li>
                        @endif
                        <li><a href="#">{{ trans("Iauth::user.create_date") }} <span class="pull-right badge bg-red">{{ $user->created_at->toDayDateTimeString() }}</span></a></li>
                        <li>
                            <a href="#">{{ trans("Iauth::user.columns.role") }}
                                <span class="pull-right badge bg-blue">
                                    <?php
                                    $roles = [];
                                    if ($user->roles()->count() > 0) {
                                        foreach ($user->roles as $role) {
                                            array_push($roles, $role->name);
                                        }
                                        echo implode("<br/>", $roles);
                                    } else {
                                        echo 'None';
                                    }
                                    ?>
                                </span>
                            </a>
                        </li>
                    </ul>
                    <a href="{{ route('profile.edit', $user->id) }}" class="btn btn-primary btn-block"><b>{{ trans('Iauth::user.buttons.actions.edit') }}</b></a>
                </div>
            </div>
            <!-- /.widget-user -->
        </div>
        <section class="col-lg-8">
            <div class="box box-success">
                <div class="box-header">
                    <i class="fa fa-list-alt"></i>
                    <h3 class="box-title">{{ trans('Iauth::dashboard.wid_invoice') }}</h3>
                </div>
                <div class="box-body scroll">
                    <table class="table no-margin">
                        <thead>
                        <tr>
                            <th class="col-sm-1">{{ trans('Invoice::invoice.inputs.serial') }}#</th>
                            <th>{{ trans('Invoice::invoice.inputs.client') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.due_date') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.grand_total') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.payment_status') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($invoices  as $invoice)
                            <?php
                            if($invoice->payment_status == "unpaid") {
                                $btn = "btn-danger";
                            } elseif ($invoice->payment_status == "paid") {
                                $btn = "btn-success";
                            } else {
                                $btn = "btn-warning";
                            }
                            ?>
                            <tr>
                                <td>
                                    <a style='border: 1px solid; padding:2px;' href="{{ route('invoice.view', $invoice->id) }}">
                                        {{ $invoice->serial }}
                                    </a>
                                </td>
                                <td>{{ $invoice->client->name }}</td>
                                <td>{{ $invoice->due_date ? Carbon\Carbon::parse($invoice->due_date)->format('Y-m-d') : '' }}</td>
                                <td>{{ $invoice->grand_total }}</td>
                                <td><button class="btn {{ $btn }} btn-xs">{{ $invoice->payment_status }}</button></td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>
    <div class="clearfix"></div>
@endsection
