<?php

namespace Modules\Currency\Requests;

use App\Http\Requests\Request;

class CurrencyRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'currency_code'     => 'required|max:30|min:3',
                    'currency_symbol'   => 'required',
                    'conversion_rate'   => '',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'currency_code'     => 'required|max:30|min:3',
                    'currency_symbol'   => 'required',
                    'conversion_rate'   => '',
                ];
            }
            default:break;
        }
    }
}
