@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-money"></i> {{ trans('Currency::currency.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Currency::currency.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('currency.list') }}"><i class="fa fa-laptop"></i>{{ trans('Currency::currency.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Currency::currency.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    {{--@roles([1])--}}
                    <a href="{{ route('currency.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Currency::currency.buttons.create') }}
                        </button>
                    </a>
                    {{--@endroles--}}
                    <table id="currencys-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ trans('Currency::currency.columns.currency_code') }}</th>
                            <th>{{ trans('Currency::currency.columns.currency_symbol') }}</th>
                            <th>{{ trans('Currency::currency.columns.conversion_rate') }}</th>
                            <th>{{ trans('Currency::currency.columns.action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#currencys-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("currency.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'currency_code', name: 'currency_code'},
                {data: 'currency_symbol', name: 'currency_symbol'},
                {data: 'conversion_rate', name: 'conversion_rate'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            order: [[0, "asc"]],
            searchDelay: 500

        });

        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();
    });
</script>
@endpush