@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal', 'enctype' => 'multipart/form-data']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($deposit, [
        'method' => 'PATCH',
        'route' => ['deposit.edit.post', $deposit->id],
        'class' => 'form-horizontal',
        'enctype' => 'multipart/form-data'
    ]) !!}
@endif

    <div class="box-body">
        <div class="form-group{{ $errors->has('bank_id') ? ' has-error' : '' }}">
            {!! Form::label('bank_id', trans("Deposit::deposit.inputs.bank_id"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::select('bank_id', $banks, null, ['class' => 'form-control select2']) !!}
                {!! $errors->first('bank_id', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
            {!! Form::label('amount', trans("Deposit::deposit.inputs.amount"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('amount', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('amount', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('date') ? ' has-error' : '' }}">
            {!! Form::label('date', trans("Deposit::deposit.inputs.date"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('date', null, ['class' => 'form-control', 'required' => 'required', 'id' => 'date']) !!}
                {!! $errors->first('date', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group">

            {{ Form::label('attachment', trans("Deposit::deposit.inputs.attach"), ['class' => 'col-lg-2 control-label']) }}

            <div class="col-lg-6">
                <div class="input-group image-preview">
                    <input type="text" class="form-control image-preview-filename" disabled="disabled">
                    <span class="input-group-btn">
                    <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                        <span class="fa fa-remove"></span>
                        Clear
                    </button>
                    <div class="btn btn-primary image-preview-input">
                        <span class="fa fa-repeat"></span>
                        <span class="image-preview-input-title">
                            File Browse
                        </span>
                        {!! Form::file('attachment', null, ['class' => 'file']) !!}
                    </div>
                </span>
                </div>
                {!! $errors->first('attachment', '<span class="help-block">:message</span>') !!}
            </div>
        </div><!--form control-->

        <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">

            {!! Form::label('description', trans("Deposit::deposit.inputs.description"), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('description', null, ['class' => 'form-control']) !!}
                {!! $errors->first('description', '<span class="help-block">:message</span>') !!}
            </div>
        </div>
    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('deposit.list', trans('Deposit::deposit.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}


@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">
<link rel="stylesheet" href="{{ url('bassets/plugins/select2/select2.min.css') }}">
<link rel="stylesheet" href="{{ url('bassets/plugins/datepicker/datepicker3.css') }}">
<style type="text/css">
    .select2-container .select2-selection--single {
        height: 34px !important;
    }
    .select2-container--default .select2-selection--single {
        border-radius: 0px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 34px !important;
    }
    .error {
        color: #a94442;
        margin: 0;
    }

    .table-error > textarea,
    .table-error > input {
        background: #f2dede;
    }
</style>
@endpush

@push('footerAssetPush')
<!-- Bootstrap WYSIHTML5 -->
<script src="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js') }}"></script>
<script src="{{ url('bassets/plugins/select2/select2.full.min.js') }}"></script>
<script src="{{ url('bassets/plugins/select2/select2.min.js') }}"></script>
<script src="{{ url('bassets/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
<script>
    $(".textarea").wysihtml5();
    $('.select2').select2();
    $('#date').datepicker({format: 'yyyy-mm-dd', autoclose: true});
</script>
@endpush
@push('footerAssetPush')
<script type="application/javascript">
    $(document).on('click', '#close-preview', function(){
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
                function () {
                    $('.image-preview').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.image-preview').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'right'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("File Browse");
        });
        // Create the preview image
        $(".image-preview-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("File Browse");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });
    });

</script>
@endpush