<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Deposit', 'prefix' => 'admin/deposit', 'namespace' => '\Modules\Deposit\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'DepositController@index')->name('deposit.list');
    Route::get('list', 'DepositController@depositDataTable')->name('deposit.list.datatable');

    Route::get('add', 'DepositController@add')->name('deposit.create');
    Route::post('add', 'DepositController@create')->name('deposit.create.post');

    Route::get('edit/{deposit}', 'DepositController@edit')->name('deposit.edit');
    Route::patch('edit/{deposit}', 'DepositController@update')->name('deposit.edit.post');

    Route::delete('delete/{deposit}', 'DepositController@delete')->name('deposit.destroy');
    Route::get('view/{deposit}', 'DepositController@view')->name('deposit.view');
    Route::get('status/{deposit}', 'DepositController@status')->name('deposit.status');

});
