<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\EmailTemplate\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\EmailTemplate\Models\EmailTemplate;
use Modules\EmailTemplate\Repositories\EmailTemplateRepository;
use Modules\EmailTemplate\Requests\EmailTemplateRequest;
use Yajra\Datatables\Facades\Datatables;
use Alert, Cache;
use Modules\EmailTemplate\Models\Tag;
class EmailTemplateController extends Controller
{
    protected $emailtemplateRepo;

    function __construct(EmailTemplateRepository $emailtemplate)
    {
        $this->emailtemplateRepo = $emailtemplate;
    }

    public function index()
    {
        return view("EmailTemplate::emailtemplateList");
    }

    public function emailtemplateDataTable()
    {
        return DataTables::of($this->emailtemplateRepo->findAll(['*']))
            ->editColumn('template', function ($emailtemplate){
                $lenth = strlen($emailtemplate->template);
                if ($lenth > 99)
                    return substr($emailtemplate->template, 0, 100)."...";
                else
                    return $emailtemplate->template;
            })
            ->addColumn('actions', function ($emailtemplate){
                return $emailtemplate->action_buttons;
            })
            ->make(true);
    }

    public function add()
    {
        $tags = Tag::pluck('tag_name')->toArray();
        return view("EmailTemplate::emailtemplateCreate")->with('tags', $tags);
    }

    public function create(EmailTemplateRequest $request)
    {
        $input = $request->all();
        $result = $this->emailtemplateRepo->create($input);

        if ($result) {
            $this->removeCached();
            Alert::success(trans("EmailTemplate::emailtemplate.alert.update_success"), 'success');
            return redirect()->route('emailtemplate.list');
        }
    }

    public function edit(EmailTemplate $emailtemplate)
    {
        $tags = Tag::pluck('tag_name')->toArray();
        return view("EmailTemplate::emailtemplateEdit")->withEmailtemplate($emailtemplate)->withTags($tags);
    }

    public function update(EmailTemplate $emailtemplate, EmailTemplateRequest $request)
    {
        $result = $this->emailtemplateRepo->update($emailtemplate, $request->all());

        if ($result) {
            $this->removeCached();
            Alert::success(trans("EmailTemplate::emailtemplate.alert.update_success"), 'success');
            return redirect()->route('emailtemplate.list');
        }
    }

    public function view(EmailTemplate $emailtemplate)
    {
        return $emailtemplate != null ? view("EmailTemplate::emailtemplateView")->withEmailTemplate($emailtemplate) :  abort(404);
    }

    public function status(EmailTemplate $emailtemplate)
    {
        $data = [];
        if ($emailtemplate->status==1) {
            $data['status'] = 0;
        } else {
            $data['status'] = 1;
        }
        $this->emailtemplateRepo->update($emailtemplate->id, $data);
        $this->removeCached();
        Alert::success(trans("EmailTemplate::emailtemplate.alert.status_success"), 'success');

        return redirect()->route('emailtemplate.list');
    }

    public function delete(EmailTemplate $emailtemplate)
    {
        $this->emailtemplateRepo->delete($emailtemplate->id);
        $this->removeCached();
        Alert::success(trans("EmailTemplate::emailtemplate.alert.delete_success"), 'success');
        return redirect()->route('emailtemplate.list');
    }

    public function removeCached()
    {
        Cache::forget('email_templates');
    }


}
