<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'EmailTemplate', 'prefix' => 'admin/emailtemplate', 'namespace' => '\Modules\EmailTemplate\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'EmailTemplateController@index')->name('emailtemplate.list');
    Route::get('list', 'EmailTemplateController@emailtemplateDataTable')->name('emailtemplate.list.datatable');

    Route::get('add', 'EmailTemplateController@add')->name('emailtemplate.create');
    Route::post('add', 'EmailTemplateController@create')->name('emailtemplate.create.post');

    Route::get('edit/{emailtemplate}', 'EmailTemplateController@edit')->name('emailtemplate.edit');
    Route::patch('edit/{emailtemplate}', 'EmailTemplateController@update')->name('emailtemplate.edit.post');

    Route::delete('delete/{emailtemplate}', 'EmailTemplateController@delete')->name('emailtemplate.destroy');
    Route::get('view/{emailtemplate}', 'EmailTemplateController@view')->name('emailtemplate.view');
    Route::get('status/{emailtemplate}', 'EmailTemplateController@status')->name('emailtemplate.status');

});
