<?php

namespace Modules\Expense\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Modules\Expense\Models\Traits\Attribute\ExpenseAttribute;
use Modules\Expense\Models\Traits\Relationship\ExpenseRelationship;

class Expense extends Model
{
    use ExpenseRelationship, ExpenseAttribute;

    // protected $table = 'expenses';

    protected $guarded = [];

    protected $hidden = [];

    /**
     * Additional fields to treat as Carbon instances.
     *
     * @var array
     */
    protected $dates = ['purchased_date'];

    /**
     * Set the purchased_date arttribute.
     *
     * @param $date
     */
    public function setPurchasedDateAttribute($date)
    {
        $this->attributes['purchased_date'] = Carbon::parse($date);
    }
    /**
     * Get the purchased_date attribute.
     * @param  $date
     * @return string
     */
    public function getPurchasedDateAttribute($date)
    {
        return Carbon::parse($date)->format('m/d/Y');
    }

}
