<?php

namespace Modules\Expense\Models\Traits\Relationship;

use Modules\ExpenseType\Models\ExpenseType;
use Modules\PaymentType\Models\PaymentType;

trait ExpenseRelationship
{

    public function user()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
    public function purchased()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
    public function paymentType()
    {
        return $this->belongsTo(PaymentType::class);
    }
    public function expenseType()
    {
        return $this->belongsTo(ExpenseType::class);
    }

}

