@if ($formFor == 'create')
    {!! Form::open(['class' => '', 'enctype' => 'multipart/form-data']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($expense, [
        'method' => 'PATCH',
        'route' => ['expense.edit.post', $expense->id],
        'class' => '',
        'enctype' => 'multipart/form-data'
    ]) !!}
@endif
<div class="box-body">
    <div class="form-group col-lg-6 col-xs-3 {{ $errors->has('expense_type_id') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('expense_type_id', trans('Expense::expense.inputs.expense_type_id'), ['class' => '']) !!}
        {!! Form::select('expense_type_id', $expense_types, null, ['class' => 'form-control select2']) !!}
        {!! $errors->first('expense_type_id', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-6 {{ $errors->has('title') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('title', trans('Expense::expense.inputs.title'), ['class' => '']) !!}
        {!! Form::text('title', null, ['class' => 'form-control']) !!}
        {!! $errors->first('title', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-6 {{ $errors->has('purchased_id') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('purchased_id', trans('Expense::expense.inputs.purchased_by'), ['class' => '']) !!}
        {!! Form::select('purchased_id', $users, null, ['class' => 'form-control select2', 'required' => 'required']) !!}
        {!! $errors->first('purchased_id', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-3 {{ $errors->has('purchased_date') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('purchased_date', trans('Expense::expense.inputs.purchased_date'), ['class' => '']) !!}
        {!! Form::text('purchased_date', date('Y-m-d'), ['class' => 'form-control']) !!}
        {!! $errors->first('purchased_date', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-3 {{ $errors->has('payment_type_id') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('payment_type_id', trans('Expense::expense.inputs.payment_type_id'), ['class' => '']) !!}
        {!! Form::select('payment_type_id', $payment_types ,null, ['class' => 'form-control select2']) !!}
        {!! $errors->first('payment_type_id', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-6 {{ $errors->has('note') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('note', trans('Expense::expense.inputs.note'), ['class' => '']) !!}
        {!! Form::textarea('note' ,null, ['class' => 'form-control']) !!}
        {!! $errors->first('note', '<span class="help-block">:message</span>') !!}
    </div>

    <div class="form-group col-lg-3 {{ $errors->has('purchased_amount') ? ' has-error' : '' }} has-feedback">
        {!! Form::label('purchased_amount', trans('Expense::expense.inputs.purchased_amount'), ['class' => '']) !!}
        {!! Form::text('purchased_amount', null, ['class' => 'form-control', 'placeholder' => '0.00']) !!}
        {!! $errors->first('purchased_amount', '<span class="help-block">:message</span>') !!}
    </div>


    <div class="form-group col-lg-3">
        {{ Form::label('attachment', trans("Expense::expense.inputs.attach"), ['class' => '']) }}
        <div class="input-group image-preview">
            <input type="text" class="form-control image-preview-filename" disabled="disabled">
            <span class="input-group-btn">
                <button type="button" class="btn btn-default image-preview-clear" style="display:none;">
                    <span class="fa fa-remove"></span>
                    Clear
                </button>
                <div class="btn btn-primary image-preview-input">
                    <span class="fa fa-repeat"></span>
                    <span class="image-preview-input-title">
                        File Browse
                    </span>
                    {!! Form::file('attachment', null, ['class' => 'file']) !!}
                </div>
            </span>
        </div>
        {!! $errors->first('attachment', '<span class="help-block">:message</span>') !!}
    </div>


    <div class="col-lg-12">
        <div class="row">
            <div class="form-group col-lg-2">
                {{ link_to_route('expense.list', trans('Expense::expense.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
            </div>
            <div class="form-group col-lg-2">
                {!! Form::submit($submitButton, ['class' => 'btn btn-success form-control']) !!}
            </div>
        </div>
    </div>
</div>
{{ Form::close() }}

@push('headerAssetPush')
<link rel="stylesheet" href="{{ url('bassets/plugins/select2/select2.min.css') }}">
<link rel="stylesheet" href="{{ url('bassets/plugins/datepicker/datepicker3.css') }}">
<style type="text/css">
    .select2-container .select2-selection--single {
        height: 34px !important;
    }
    .select2-container--default .select2-selection--single {
        border-radius: 0px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 34px !important;
    }
</style>
@endpush

@push('footerAssetPush')
<script src="{{ url('bassets/plugins/select2/select2.full.min.js') }}"></script>
<script src="{{ url('bassets/plugins/select2/select2.min.js') }}"></script>
<script src="{{ url('bassets/plugins/datepicker/bootstrap-datepicker.js') }}"></script>

<script>
    $('.select2').select2();
    $('#purchased_date').datepicker({format: 'yyyy-mm-dd', autoclose: true});
    // attach file form
    $(document).on('click', '#close-preview', function(){
        $('.image-preview').popover('hide');
        // Hover befor close the preview
        $('.image-preview').hover(
                function () {
                    $('.image-preview').popover('show');
                    $('.content').css('padding-bottom', '100px');
                },
                function () {
                    $('.image-preview').popover('hide');
                    $('.content').css('padding-bottom', '20px');
                }
        );
    });

    $(function() {
        // Create the close button
        var closebtn = $('<button/>', {
            type:"button",
            text: 'x',
            id: 'close-preview',
            style: 'font-size: initial;',
        });
        closebtn.attr("class","close pull-right");
        // Set the popover default content
        $('.image-preview').popover({
            trigger:'manual',
            html:true,
            title: "<strong>Preview</strong>"+$(closebtn)[0].outerHTML,
            content: "There's no image",
            placement:'bottom'
        });
        // Clear event
        $('.image-preview-clear').click(function(){
            $('.image-preview').attr("data-content","").popover('hide');
            $('.image-preview-filename').val("");
            $('.image-preview-clear').hide();
            $('.image-preview-input input:file').val("");
            $(".image-preview-input-title").text("File Browse");
        });
        // Create the preview image
        $(".image-preview-input input:file").change(function (){
            var img = $('<img/>', {
                id: 'dynamic',
                width:250,
                height:200,
                overflow:'hidden'
            });
            var file = this.files[0];
            var reader = new FileReader();
            // Set preview image into the popover data-content
            reader.onload = function (e) {
                $(".image-preview-input-title").text("File Browse");
                $(".image-preview-clear").show();
                $(".image-preview-filename").val(file.name);
                img.attr('src', e.target.result);
                $(".image-preview").attr("data-content",$(img)[0].outerHTML).popover("show");
                $('.content').css('padding-bottom', '100px');
            }
            reader.readAsDataURL(file);
        });
    });

</script>

@endpush
