<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Modules\Iauth\Models\Access\Permission\Permission;
use Modules\Iauth\Models\Access\Role\Role;
use Modules\Iauth\Repositories\Access\Permission\PermissionAssignRepositoryContract;
use Modules\Iauth\Repositories\Access\Permission\PermissionRepositoryContract;
use Yajra\Datatables\Facades\Datatables;
use Alert, Cache;

class PermissionAssignController extends Controller
{
    protected $permissionAssignRepo;

    public function __construct(PermissionAssignRepositoryContract $permissionAssign)
    {
        $this->permissionAssignRepo = $permissionAssign;
    }

    public function index()
    {
        $allPermission      = Permission::orderBy('display_name')->whereStatus(1)->get();
        $makePermissionArray = [];
        foreach ($allPermission as $permission) {
            $explodeArray       = explode('-', $permission->name, 2);
            if(count($explodeArray) == 1) {
                $makePermissionArray[$explodeArray[0]]['this'] = $permission;
            } else {
                $makePermissionArray[$explodeArray[0]][$explodeArray[1]] = $permission;
            }
        }
        $rolePermission = $this->permissionAssignRepo->getRolePermissionAccess()->pluck('active', 'role_permission');
        return view('Iauth::permission.permissionAssign')
                ->withRolePermission($rolePermission)
                ->withRoles(Role::orderBy('sort')->get())
                ->withPermissions($makePermissionArray);
    }

    public function update(Request $request)
    {
        $this->permissionAssignRepo->updateRolePermissionAccess($request->except('_token'));
        Cache::forget('permission-role-relation');
        Alert::success(trans("Iauth::permission.alert.update_success"), 'success');
        return redirect()->route('permission.assign');
    }

}