<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Listeners\Access\User\Mail;

use Modules\Iauth\Events\Access\User\Mail\UserRegistered;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Mail;

class NewUserRegistered
{
//    use InteractsWithQueue;
    /**
     * Create the event listener.
     *
     * @return void
     */
//    public function __construct()
//    {
//        //
//    }
    /*
     * Send email to new User
     */
    public function onCreated($event) {
        $title      = "<h2>Thanks for signing up!</h2>";
        $content    = "<h4>Hi ". $event->user->username. ",</h4><br>";
        $content    .= "<h3>Welcome to iStart iNiLabs BaseApp Application</h3>";
        $content    .= "<p>It's really great to have you around. You're now free to create new application with our baseapp, explore our documentation and boost your project quality and optimize your production time.</p>";

        Mail::send('emails.send', ['title' => $title, 'content' => $content], function ($message) use ($event)
        {

            $message->from('rid.infinite@gmail.com', 'Rid Islam');
            $message->to($event->user->email);

        });
    }
    /**
     * Handle the event.
     *
     * @param  UserRegistered  $event
     * @return void
     */
    /*public function handle(UserRegistered $event)
    {
        $title      = "<h2>Thanks for signing up!</h2>";
        $content    = "<h4>Hi ". $event->user->username. ",</h4><br>";
        $content    .= "<h3>Welcome to iStart iNiLabs BaseApp Application</h3>";
        $content    .= "<p>It's really great to have you around. You're now free to create new application with our baseapp, explore our documentation and boost your project quality and optimize your production time.</p>";

        Mail::send('emails.send', ['title' => $title, 'content' => $content], function ($message) use ($event)
        {

            $message->from('rid.infinite@gmail.com', 'Rid Islam');
            $message->to($event->user->email);

        });
    }*/

    public function subscribe($events)
    {
        $events->listen(
            \Modules\Iauth\Events\Access\User\Mail\UserRegistered::class,
            'Modules\Iauth\Listeners\Access\User\Mail\NewUserRegistered@onCreated'
        );
    }
}
