<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Models\Access\Permission;

use Illuminate\Database\Eloquent\Model;
use Modules\Iauth\Models\Access\Permission\Traits\Attribute\PermissionAttribute;
use Modules\Iauth\Models\Access\Permission\Traits\PermissionAccess;
use Modules\Iauth\Models\Access\Permission\Traits\Relationship\PermissionRelationship;

/**
 * Class Permission
 * @package Modules\Iauth\Models\Access\Permission
 */
class Permission extends Model
{
    use PermissionRelationship, PermissionAttribute, PermissionAccess;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['name', 'display_name', 'description', 'status'];

    /**
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = config('core.acl.permissions_table');
    }
}