<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Models\Access\User\Traits\Attribute;
use Modules\Iauth\Models\Access\User\User;
use Auth;

/**
 * Class UserAttribute
 * @package Modules\Iauth\Models\Access\User\Traits\Attribute
 */
trait UserAttribute
{
    protected $route = 'user';

    /**
     * @return mixed
     */
    public function canChangeEmail()
    {
        return config('core.acl.users.change_email');
    }

    /**
     * @return bool
     */
    public function canChangePassword()
    {
        return ! app('session')->has(config('core.socialite_session_name'));
    }

    /**
     * @return string
     */
    public function getConfirmedLabelAttribute()
    {
        if ($this->isValidEmail())
            return "<label class='label label-success'>".trans('labels.general.yes')."</label>";
        return "<label class='label label-danger'>".trans('labels.general.no')."</label>";
    }

    /**
     * @return mixed
     */
    public function getPictureAttribute()
    {
        return $this->getPicture();
    }

    /**
     * @param bool $size
     * @return mixed
     */
    public function getPicture($size = false)
    {
        if (! $size) $size = config('gravatar.default.size');
        return gravatar()->get($this->email, ['size' => $size]);
    }

    /**
     * @param $provider
     * @return bool
     */
    public function hasProvider($provider)
    {
        foreach ($this->providers as $p) {
            if ($p->provider == $provider) {
                return true;
            }
        }

        return false;
    }

    /**
     * @return bool
     */
    public function isActive() {
        return $this->status == 1;
    }

    /**
     * @return bool
     */
    public function isValidEmail() {
        return $this->is_valid_email == 1;
    }

    /**
     * @return string
     */
    public function getViewButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@user-view')) {
            return '<a href="' . route($this->route.'.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('Iauth::user.buttons.actions.view') . '"></i></a> ';
        }

        return '';
    }

    /**
     * @return string
     */
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@user-edit')) {
            return '<a href="' . route($this->route.'.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Iauth::user.buttons.actions.edit') . '"></i></a> ';
        }

        return '';
    }

    /**
     * @return string
     */
    public function getChangePasswordButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@user-password-update')) {
            return '<a href="' . route($this->route.'.change-password', $this) . '" class="btn btn-xs btn-info"><i class="fa fa-lock" data-toggle="tooltip" data-placement="top" title="' . trans('Iauth::user.buttons.actions.change_password') . '"></i></a> ';
        }

        return '';
    }

    /**
     * @return string
     */
    public function getStatusButtonAttribute()
    {
        if ($this->id != auth()->id() && Auth::user()->hasPermission('admin@user-status')) {
            switch ($this->status) {
                case 0:
                    return '<a href="' . route('user.status.change', [
                        $this,
                        1
                    ]) . '" class="btn btn-xs btn-success"><i class="fa fa-play" data-toggle="tooltip" data-placement="top" title="' . trans('Iauth::user.buttons.actions.activate') . '"></i></a> ';
                // No break

                case 1:
                    return '<a href="' . route('user.status.change', [
                        $this,
                        0
                    ]) . '" class="btn btn-xs btn-warning"><i class="fa fa-pause" data-toggle="tooltip" data-placement="top" title="' . trans('Iauth::user.buttons.actions.deactivate') . '"></i></a> ';
                // No break

                default:
                    return '';
                // No break
            }
        }

        return '';
    }

    /**
     * @return string
     */
    public function getConfirmedButtonAttribute()
    {
        if (! $this->isValidEmail() && Auth::user()->hasPermission('admin@user-emailconfirmation')) {
            return '<a href="' . url('user.email.confirm.resend', $this) . '" class="btn btn-xs btn-success"><i class="fa fa-refresh" data-toggle="tooltip" data-placement="top" title=' . trans('buttons.backend.access.users.resend_email') . '"></i></a> ';
        }

        return '';
    }

    /**
     * @return string
     */
    public function getDeleteButtonAttribute()
    {
        if ($this->id != auth()->id() && Auth::user()->hasPermission('admin@user-delete')) {
            return '<a href="' . route('user.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="Cancel"
                 data-trans-button-confirm="Delete"
                 data-trans-title="Are you sure?"
                 class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Iauth::user.buttons.actions.delete') . '"></i></a> ';
        }

        return '';
    }

	/**
     * @return string
     */
    public function getRestoreButtonAttribute()
    {
        return '<a href="' . url('user.restore', $this) . '" name="restore_user" class="btn btn-xs btn-info"><i class="fa fa-refresh" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.restore_user') . '"></i></a> ';
    }

	/**
     * @return string
     */
    public function getDeletePermanentlyButtonAttribute()
    {
        return '<a href="' . url('user.delete-permanently', $this) . '" name="delete_user_perm" class="btn btn-xs btn-danger"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.delete_permanently') . '"></i></a> ';
    }

	/**
     * @return string
     */
    public function getLoginAsButtonAttribute()
    {
        /**
         * If the admin is currently NOT spoofing a user
         */
        if (! session()->has("admin_user_id") || ! session()->has("temp_user_id")) {
            //Won't break, but don't let them "Login As" themselves
            if ($this->id != auth()->id()) {
                return '<a href="' . url('user.login-as',
                    $this) . '" class="btn btn-xs btn-success"><i class="fa fa-lock" data-toggle="tooltip" data-placement="top" title="' . trans('buttons.backend.access.users.login_as',
                    ['user' => $this->name]) . '"></i></a> ';
            }
        }

        return '';
    }
    
    /**
     * @return string
     */
    public function getNameAttribute()
    {
        return $this->first_name.' '.$this->last_name;
    }

    /**
     * @return string
     */
    public function getActionButtonsAttribute($route)
    {
        if($route != null) {
            $this->route = $route;
        }

        if ($this->deleted_at) {
            return $this->getRestoreButtonAttribute() .
                $this->getDeletePermanentlyButtonAttribute();
        }

        return
//            $this->getLoginAsButtonAttribute() .
            $this->getViewButtonAttribute() .
            $this->getEditButtonAttribute() .
            $this->getChangePasswordButtonAttribute() .
            $this->getStatusButtonAttribute() .
            $this->getConfirmedButtonAttribute() .
            $this->getDeleteButtonAttribute();
    }

}
