<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Models\Access\User\Traits\Relationship;
use Modules\Invoice\Models\Invoice;
use Modules\Invoice\Models\Payment;
use Modules\Product\Models\Product;

/**
 * Class UserRelationship
 * @package Modules\Iauth\Models\Access\User\Traits\Relationship
 */
trait UserRelationship
{
    
    /**
     * Many-to-Many relations with Role.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles()
    {
        return $this->belongsToMany(config('core.acl.role'), config('core.acl.assigned_roles_table'), 'user_id', 'role_id');
    }

    /**
     * @return mixed
     */
    public function social()
    {
        return $this->hasMany(config('core.socialite.model'));
    }

    public function hasSocialLinked($service)
    {
        return (bool) $this->social->where('service', $service)->count();
    }

    public function notices()
    {
        return $this->hasMany('Modules\Notice\Models\Notice');
    }

    public function todos()
    {
        return $this->hasMany('Modules\Todo\Models\Todo');
    }

    public function posts()
    {
        return $this->hasMany('Modules\Post\Models\Post');
    }

    public function expenses()
    {
        return $this->hasMany('Modules\Expense\Models\Expense');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function hasOneRelation($model)
    {
        return $this->hasOne($model);
    }
}