<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Requests;

use App\Http\Requests\Request;
use Modules\Iauth\Models\Access\Role\Role;

class RoleRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $role = $this->route('role'); // this id is route parameter name;

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'name' => 'required|max:20|unique:roles,name',
                    'sort' => 'required|numeric|min:1',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'name' => 'required|max:20|unique:roles,name,'.$role->name.',name',
                    'sort' => 'required|numeric|min:1',
                ];
            }
            default:break;
        }
    }
}
