<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Iauth\Requests;

use App\Http\Requests\Request;
use Modules\Iauth\Models\Access\User\User;

class UserCreateAndUpdateRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $user = $this->route('user'); // this is route parameter name

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'username' => 'required|max:20|min:3|alpha_dash|unique:users,username',
                    'first_name' => 'max:30',
                    'last_name' => 'max:30',
                    'email' => 'required|email|unique:users,email',
                    'password' => 'required|min:5|confirmed',
                    'password_confirmation' => 'required|same:password',
                    'img' => 'max:255',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'username' => 'required|max:20|min:3|unique:users,username,'.$user->id.',id',
                    'email' => 'required|email|unique:users,email,'.$user->email.',email',
                    'first_name' => 'max:30',
                    'last_name' => 'max:30',
                    'img' => 'max:255',
                ];
            }
            default:break;
        }
    }
}
