@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($permission, [
        'method' => 'PATCH',
        'route' => ['permission.edit', $permission->id],
        'class' => 'form-horizontal'
    ]) !!}
@endif
    <div class="box-body">
        <div class="form-group{{ $errors->has('display_name') ? ' has-error' : '' }}">

            {!! Form::label('display_name', trans('Iauth::permission.inputs.display_name'), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('display_name', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('display_name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">

            {!! Form::label('name', trans('Iauth::permission.inputs.name'), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::text('name', null, ['class' => 'form-control', 'required' => 'required']) !!}
                {!! $errors->first('name', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">

            {!! Form::label('description', trans('Iauth::permission.inputs.description'), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                {!! Form::textarea('description', null, ['class' => 'form-control', 'size' => '50x5']) !!}
                {!! $errors->first('description', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group">

            {!! Form::label('action', trans('Iauth::permission.inputs.description'), ['class' => 'col-lg-2 control-label']) !!}

            <div class="col-lg-6">
                <input type="checkbox" value="view" name="permission_action[]" @if ($formFor == 'edit') {{in_array($permission->name.'-view', $sub_permissions) ? 'checked' : ''}} @endif id="permission-view" /> <label for="permission-view">View</label>
                <br/>
                <input type="checkbox" value="add" name="permission_action[]" @if ($formFor == 'edit') {{in_array($permission->name.'-add', $sub_permissions) ? 'checked' : ''}} @endif id="permission-add" /> <label for="permission-add">Add</label>
                <br/>
                <input type="checkbox" value="edit" name="permission_action[]" @if ($formFor == 'edit') {{in_array($permission->name.'-edit', $sub_permissions) ? 'checked' : ''}} @endif id="permission-edit" /> <label for="permission-edit">Edit</label>
                <br/>
                <input type="checkbox" value="delete" name="permission_action[]" @if ($formFor == 'edit') {{in_array($permission->name.'-delete', $sub_permissions) ? 'checked' : ''}} @endif id="permission-delete" /> <label for="permission-delete">Delete</label>
                <br/>
                @if($formFor == 'edit')
                    {{--{{ dd($permission->subPermissions()->pluck('name')) }}--}}
                    @foreach($permission->subPermissions()->pluck('name') as $sub_permission)
                        @if($permission->name.'-view' == $sub_permission || $permission->name.'-add' == $sub_permission || $permission->name.'-edit' == $sub_permission || $permission->name.'-delete' == $sub_permission)
                            @continue
                        @endif
                        @php($afterHipenString = substr(strstr($sub_permission, '-'),1))
                        <input type="checkbox" value="{{ $afterHipenString }}" name="permission_action[]" @if ($formFor == 'edit') {{in_array($sub_permission, $sub_permissions) ? 'checked' : ''}} @endif id="permission-{{ $afterHipenString }}" /> <label for="permission-{{ $afterHipenString }}">{{ ucfirst($afterHipenString) }}</label>
                        <br/>
                    @endforeach
                @endif
            </div>
        </div>

    </div>
    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('permission.list', trans('Iauth::permission.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>

            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->

{{--{!! Form::submit($submitButton, ['class' => 'btn btn-success form-control']) !!}--}}
{{ Form::close() }}