<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/


Route::group(['Module' => 'Iauth', 'namespace' => '\Modules\Iauth\Controllers', 'middleware' => ['web', 'installer']], function () {
    Route::get('password/reset/{token}', 'ResetPasswordController@showResetForm')->name('admin.password.reset.with.token');
    Route::post('password/reset', 'ResetPasswordController@reset')->name('admin.password.reset.with.token.post');
});
Route::group(['Module' => 'Iauth', 'prefix' => 'admin', 'namespace' => '\Modules\Iauth\Controllers', 'middleware' => ['web', 'installer']], function() {

    Route::group(array('middleware' => 'notauth'), function() {

        Route::get('login', function() {
            return view('backend::pages.login');
        })->name('admin.login');
        Route::post('login', 'IauthController@login')->name('admin.login.post');

        // Password Reset Routes...
        Route::get('password/reset', 'ForgotPasswordController@showLinkRequestForm')->name('admin.password.reset');
        Route::post('password/email', 'ForgotPasswordController@sendResetLinkEmail')->name('admin.password.email');

    });


    Route::group(['middleware' => ['auth']], function() {

        Route::get('/', 'IauthController@home')->name('backend.root');

        Route::get('home', 'IauthController@home')->name('backend.home');
        Route::post('day_income_or_income', 'IauthController@dayWiseExpenseOrIncome')->name('day.wise.income.expense');

        Route::get('profile/', 'IauthController@profile')->name('profile');
        Route::get('profile/{user}', 'IauthController@profileEdit')->name('profile.edit');
        Route::patch('profile/{user}', 'IauthController@updateProfileEdit')->name('profile.edit.post');

        Route::get('logout', 'IauthController@logout')->name('backend.logout');

        Route::post('admin/user/multidelete', 'IauthController@multiDelete')->name('user.multi.delete');

        Route::group(['prefix' => 'user', 'middleware' => 'acl'], function () {

            Route::get('/', 'IauthController@userList')->name('user.list');

            Route::get('list', 'IauthController@userDataTable')->name('user.list.datatable');

            Route::get('add', 'IauthController@add')->name('user.add');
            Route::post('add', 'IauthController@create')->name('user.add.post');

            Route::get('edit/{user}', 'IauthController@edit')->name('user.edit');
            Route::patch('edit/{user}', 'IauthController@update')->name('user.edit.post');

            Route::get('view/{user}', 'IauthController@view')->name('user.view');

            Route::delete('delete/{user}', 'IauthController@delete')->name('user.destroy');

            Route::get('status/{user}/{status}', 'IauthController@status')->name('user.status.change')->where(['status' => '[0,1]']);

            Route::get('password/update/{user}', 'IauthController@changePassword')->name('user.change-password');
            Route::post('password/update/{user}', 'IauthController@updatePassword')->name('user.update-password.post');

            Route::get('password/update', 'IauthController@changeProfilePassword')->name('user.change-profile-password');
            Route::post('password/update', 'IauthController@updateProfilePassword')->name('user.update-profile-password.post');

        });

        Route::group(['prefix' => 'role', 'middleware' => 'acl'], function () {

            Route::get('/', 'RoleController@index')->name('role.list');

            Route::get('list', 'RoleController@roleDataTable')->name('role.list.datatable');

            Route::get('add', 'RoleController@add')->name('role.add');

            Route::post('add', 'RoleController@create')->name('role.add.post');

            Route::get('edit/{role}', 'RoleController@edit')->name('role.edit');
            Route::patch('edit/{role}', 'RoleController@update')->name('role.edit.post');

            Route::delete('delete/{role}', ['uses' => 'RoleController@delete'])->name('role.delete');

        });

        Route::group(['prefix' => 'permission'], function () {

            Route::get('/', 'PermissionController@index')->name('permission.list');

            Route::get('list', 'PermissionController@permissionDataTable')->name('permission.list.datatable');

            Route::get('add', 'PermissionController@add')->name('permission.add');

            Route::post('add', 'PermissionController@create')->name('permission.add.post');

            Route::get('edit/{permission}', 'PermissionController@edit')->name('permission.edit');
            Route::patch('edit/{permission}', 'PermissionController@update')->name('permission.edit.post');

            Route::get('status/{permission}/{status}', 'PermissionController@status')->name('permission.status.change')->where(['status' => '[0,1]']);

            Route::get('auto', 'PermissionController@auto')->name('permission.auto');

        });


        Route::group(['prefix' => 'permission/assign'], function () {

            Route::get('/', 'PermissionAssignController@index')->name('permission.assign');

            Route::post('update', 'PermissionAssignController@update')->name('permission.assign.update');
        });

        Route::get('hasrole', function () {
            dd(Auth::user()->hasrole(1));
        });

        Route::get('haspermission', function () {
            dd(Auth::user()->hasPermissions(['user-delete', 'user-edit'], false));
        });

    });

});
