<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Installer\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Modules\History\Models\History\HistoryType;
use Modules\Iauth\Repositories\Access\Permission\PermissionRepositoryContract;
use Modules\Installer\Requests\AdminUserRequest;
use Modules\Installer\Requests\InstallerRequest;
use Modules\Installer\Requests\PurchaseCodeRequest;
use Modules\Installer\Requests\SiteSettingsRequest;
use Installer, Config, View, App, Route, Alert;

class InstallerController extends Controller
{

    protected $extension;

    protected $filePermission;

    protected $permissionRepo;

    protected $finishRedirectPath = 'admin/home';

    public function __construct(PermissionRepositoryContract $permission)
    {
        $this->extension        = $this->checkPhpExtension();
        $this->filePermission   = $this->checkFolderAndFilePermission();
        $this->permissionRepo   = $permission;
        View::share('extension', $this->extension);
        View::share('permission', $this->filePermission);
    }

    public function index()
    {
        session(['_old_input' => '']);
        return view('Installer::install');
    }

    public function checkPhpExtension()
    {
        $forCheck = ['phpVersion' , 'pdoLibrary', 'mbstring', 'openssl', 'curl', 'zip', 'gd', 'tokenizer', 'xml'];
        $extensionResult = [];
        foreach ($forCheck as $item) {
            $extensionResult[$item] = Installer::checkExtension($item);
        }
        return $extensionResult;
    }

    public function purchaseCodeView()
    {
        return view('Installer::install')->with(['nextView' => 'welcome']);
    }

    public function checkPurchaseCode(PurchaseCodeRequest $request)
    {
        return view('Installer::install')->with(['nextView' => 'permission']);
    }

    public function checkFolderAndFilePermission()
    {
        $forCheck = ['storage/app/' , 'storage/framework/', 'storage/logs/', 'bootstrap/cache/', 'public', 'config', '.env'];
        $filePermissionResult = [];
        foreach ($forCheck as $key => $item) {
            if($item == '.env' && !file_exists(base_path('.env'))) {
                $filePermissionResult[$key] = 'not exit';
                continue;
            }

            $filePermissionResult[$key] = Installer::checkPermission($item);
        }
        return $filePermissionResult;
    }

    public function save(InstallerRequest $input)
    {
        $input = $input->except(['_token']);
        $key = 'DB_DATABASE';
        $value = 'shipu';
        $configKey = 'database.connections.mysql.database';
        Installer::setDriver($input['driver']);

        try {
            if(file_exists(App::environmentFilePath())) {
                foreach ($input as $key => $value) {
                    Installer::setInEnvironment($key, $value);
                }
                Artisan::call('config:clear');
            } else {
                $port       = $input['port'] != '' ? $input['port'] : ($input['driver']=='mysql' ? '3306' : '5432') ;
                $search     = ['DummyDriver', 'DummyHost', 'DummyDatabase', 'DummyUsername', 'DummyPassword', 'DummyPort'];
                $replace    = [$input['driver'], $input['host'], $input['database'], $input['username'], $input['password'], $port];
                file_put_contents(config_path('database.php'),str_replace(
                    $search,
                    $replace,
                    file_get_contents(base_path('Core/src/Providers/Console/Commands/stubs/database.stub'))
                ));
            }
            session(['_old_input' => $input]);
            return view('Installer::install')->with(['nextView' => 'site']);
        } catch (\PDOException $e) {

        }

    }

    public function siteSettingsSave(SiteSettingsRequest $inputs)
    {
        try {
            Artisan::call('migrate', ['--force' => true]);
            $settings   = Config::get('installer.settings');

            $inputs = $inputs->except(['_token']);
            foreach ($inputs as $option => $value) {
                $settings::updateOrInsert(['option' => $option],['value' => $value]);
            }

            file_put_contents(config_path('app.php'), str_replace(
                "'timezone' => '".Config::get('app.timezone')."'",
                "'timezone' => '".$inputs['timezone']."'",
                file_get_contents(config_path('app.php'))
            ));
            Config::set('app.timezone', $inputs['timezone']);
            session(['_old_input' => $inputs]);
            return redirect('install/user');
        } catch (\PDOException $e) {
            abort(500, "Database Connection Problem");
        }


    }

    public function adminUserForm()
    {
        return view('Installer::install')->with(['nextView' => 'user']);
    }

    public function adminUserSave(AdminUserRequest $inputs)
    {
        $this->auto();

        $historyTypes = ['User', 'Role', 'Notice', 'Todo'];
        foreach ($historyTypes as $historyType) {
            HistoryType::create(['name' => $historyType]);
        }

        $role   = Config::get('installer.role');
        $data   = Config::get('installer.default_role');

        $adminID    = $role::create($data[0]);
        $userID     = $role::create($data[1]);

        foreach ($data as $defaultRole) {
            if($defaultRole['name'] == 'Admin' || $defaultRole['name'] == 'User') {
                continue;
            }
            $role::create($defaultRole);
        }

        $pemission      = Config::get('installer.permission');
        $allPermission  = $pemission::where('status', '=', 1)->get()->pluck('id');

        $adminID->attachPermissions($allPermission);

        $user   = Config::get('installer.user');
        $inputs['confirmation_code'] = md5(uniqid(mt_rand(), true));
        $inputs['status']            = 1;
        $inputs['is_valid_email']    = 1;
        $inputs['img']               = 'public/assets/img/profile/default.png';
        $inputs['password']          = bcrypt($inputs['password']);
        $user = $user::create($inputs->except('password_confirmation'));
        $user->attachRole($adminID);

        Artisan::call('db:seed', ['--class' => 'ClientPermissionTableSeeder']);
        Artisan::call('db:seed', ['--class' => 'PaymentTypesTableSeeder']);

        if(file_exists(App::environmentFilePath())) {
            Installer::setInstallKeyOnEnv();
        }else {
            file_put_contents(config_path('database.php'),str_replace(
                "'install' => env('APP_INSTALL', false)",
                "'install' => env('APP_INSTALL', true)",
                file_get_contents(config_path('database.php'))
            ));
        }
        return view('Installer::install')->with(['nextView' => 'finish']);
    }

    public function finishInstallProcess()
    {
        return redirect($this->finishRedirectPath);
    }

    public function auto()
    {
        $routeCollection = Route::getRoutes();

        $allRouteLikeDatabase   = [];
        foreach ($routeCollection as $value) {
            $middleware         =   false;
            if ( isset($value->getAction()['middleware']) && is_array($value->getAction()['middleware']) ) {
                $middleware     =   in_array('acl', $value->getAction()['middleware']);
            }

            if ($middleware) {
                $permission                     =   [];
                $explodeUrl                     =   explode('/', $value->getpath());
                $countExplode                   =   count($explodeUrl);

                for ($i = 1; $i <= $countExplode; $i++) {
                    if($explodeUrl[$i-1][0] != '{') {
                        if($i == 1) {
                            $permission['name']             =   $explodeUrl[$i-1];
                            $permission['display_name']     =   ucfirst($explodeUrl[$i-1]);
                        } elseif($i==2 && $explodeUrl[$i-2] == 'admin') {
                            $permission['name']             .=   '@'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        } else {
                            $permission['name']             .=   '-'.$explodeUrl[$i-1];
                            $permission['display_name']     .=   ' '.ucfirst($explodeUrl[$i-1]);
                        }

                    }
                }

                $allRouteLikeDatabase[]         =   $permission['name'];
                if(isset($permission)) {
                    $status = $this->permissionRepo->firstOrCreate($permission);
                }
            }
        }

        $deletePermissionFromDatabaseWithCheckRoutes   =   array_count_values(array_merge($this->permissionRepo->getAllPermissions()->pluck('name')->all(), $allRouteLikeDatabase));

        foreach ($deletePermissionFromDatabaseWithCheckRoutes as $name => $value) {
            if($value == 1) {
                $this->permissionRepo->deleteWithPermissionName($name);
            }
        }
    }

}
