<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Installer\Requests;

use App\Http\Requests\Request;
use Response;
use View;

class AdminUserRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'username' => 'required|max:20|min:3|alpha_dash|unique:users,username',
                    'first_name' => 'max:30',
                    'last_name' => 'max:30',
                    'email' => 'required|email|unique:users,email',
                    'password' => 'required|min:5|confirmed',
                    'password_confirmation' => 'required|same:password'
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [

                ];
            }
            default:break;
        }
    }

}
