<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Installer\Requests;

use App\Http\Requests\Request;

class PurchaseCodeRequest extends Request
{

    protected $redirect = 'install/code';

    public function authorize()
    {
        return true;
    }

    public function rules()
    {

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'envato_username'  => 'required',
                    'envato_purchase_code'  => 'required|envato',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [

                ];
            }
            default:break;
        }
    }

    public function messages()
    {
        return [
            'envato' => 'Sorry you\'re purchase info not valid.'
        ];
    }
}
