<template id="user">
    <fieldset>
        <form method="post" action="{{ url('install/user') }}">
            {{ csrf_field() }}
            <h2 class="fs-title">Admin User Info</h2>
            <h3 class="fs-subtitle">Prepare your root admin user credentials.</h3>
            @if(count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                <br/>
            @endif
            <input  type="text" name="first_name" placeholder="First Name" value="{{ old('first_name') }}" required/>
            <input  type="text" name="last_name" placeholder="Last Name" value="{{ old('last_name') }}" required/>
            <input  type="text" name="username" placeholder="User Name" value="{{ old('username') }}" required/>
            <input  type="email" name="email" placeholder="Email" value="{{ old('email') }}" required/>
            <input  type="password" name="password" placeholder="Password" value="" required/>
            <input  type="password" name="password_confirmation" placeholder="Re-type Password" value="" required/>

            <button @click="nextorprevious('site')" class="previous action-button"> Previous </button>
            {{--<button @click.prevent="nextorprevious('permission')" class="next action-button"> Next </button>--}}
            <input type="submit"  class="next action-button" value="Next" />
        </form>
    </fieldset>
</template>