<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('client_id')->unsigned();
            $table->integer('paymenttype_id')->unsigned()->nullable();
            $table->integer('tax_id')->unsigned()->nullable();
            $table->decimal('sub_total')->nullable();
            $table->decimal('discount')->nullable();
            $table->decimal('grand_total')->nullable();
            $table->timestamp('create_date')->nullable();
            $table->timestamp('due_date')->nullable();
            $table->timestamp('paid_date')->nullable();
            $table->string('serial')->nullable();
            $table->string('note')->nullable();
            $table->text('token')->nullable();
            $table->text('terms_conditions')->nullable();
            $table->string('payment_status')->nullable();
            $table->integer('user_id')->unsigned();
            $table->timestamps();
            /**
             * Add Foreign/Unique/Index
             */

            $table->foreign('client_id')
                ->references('id')
                ->on(config('core.acl.users_table'))
                ->onDelete('cascade');
            $table->foreign('user_id')
                ->references('id')
                ->on(config('core.acl.users_table'))
                ->onDelete('cascade');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('invoices');
        Schema::enableForeignKeyConstraints();
    }
}
