<?php

namespace Modules\Invoice\Models\Traits\Relationship;



use Modules\Client\Models\Client;
use Modules\Currency\Models\Currency;
use Modules\Invoice\Models\OrderItem;
use Modules\Invoice\Models\Payment;
use Modules\PaymentType\Models\PaymentType;
use Modules\Tax\Models\Tax;

trait InvoiceRelationship
{
    public function user()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
    public function client()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
    public function products()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function paymenttype()
    {
        return $this->belongsTo(PaymentType::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

}

