<?php

namespace Modules\Invoice\Models\Traits\Relationship;

use Modules\Bank\Models\BankPayment;
use Modules\Invoice\Models\Invoice;

trait PaymentRelationship
{
    public function user()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
    public function bankPayments()
    {
        return $this->hasMany(BankPayment::class);
    }

}

