<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Invoice\Requests;

use App\Http\Requests\Request;

class PaymentRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'grand_total'   => '',
                    'paying_amount'   => 'required|regex:/(\d+(\.\d+)?)/',
                    'payment_option'  => 'required',
                    'card_number'  => 'numeric',
                    'name'  => '',
                    'billing_address'  => '',
                    'cvv'  => 'numeric',
                    'expire_month'  => 'numeric',
                    'expire_year'  => 'numeric',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [];
            }
            default:break;
        }
    }
}
