<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Invoice\Requests;

use App\Http\Requests\Request;

class PaymentSettingsRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        session(['tab' => 'payment']);
        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'payment_paypal_username'   => '',
                    'payment_paypal_password'   => '',
                    'payment_paypal_signature'  => '',
                    'payment_stripe_secret_key'  => '',
                    'payment_twocheckout_secret_word'  => '',
                    'payment_twocheckout_account'  => '',
                    'site_currency_symbol'  => '',
                    'site_currency_code'  => '',
                    'payment_sandbox_status'  => '',
                ];
            }
            default:break;
        }
    }
}
