<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Invoice\Services;

use Cache;

class Settings
{

    function __construct()
    {

    }

    public function bindSettingsTab()
    {
        return bind_settings_tab('payment', trans('Invoice::invoice.settings.tab'));
    }

    public function bindSettingsTabContent()
    {
        $data = [
            'payment_paypal_username' => isset(Cache::get('settings')['payment_paypal_username']) ? Cache::get('settings')['payment_paypal_username'] : '',
            'payment_paypal_password' => isset(Cache::get('settings')['payment_paypal_password']) ? Cache::get('settings')['payment_paypal_password'] : '',
            'payment_paypal_signature' => isset(Cache::get('settings')['payment_paypal_signature']) ? Cache::get('settings')['payment_paypal_signature'] : '',
            'payment_stripe_secret_key' => isset(Cache::get('settings')['payment_stripe_secret_key']) ? Cache::get('settings')['payment_stripe_secret_key'] : '',
            'payment_twocheckout_secret_word' => isset(Cache::get('settings')['payment_twocheckout_secret_word']) ? Cache::get('settings')['payment_twocheckout_secret_word'] : '',
            'payment_twocheckout_account' => isset(Cache::get('settings')['payment_twocheckout_account']) ? Cache::get('settings')['payment_twocheckout_account'] : '',
            'payment_payumoney_merchantID' => isset(Cache::get('settings')['payment_payumoney_merchantID']) ? Cache::get('settings')['payment_payumoney_merchantID'] : '',
            'payment_payumoney_secretkey' => isset(Cache::get('settings')['payment_payumoney_secretkey']) ? Cache::get('settings')['payment_payumoney_secretkey'] : '',
            'site_currency_code' => isset(Cache::get('settings')['site_currency_code']) ? Cache::get('settings')['site_currency_code'] : '',
            'site_currency_symbol' => isset(Cache::get('settings')['site_currency_symbol']) ? Cache::get('settings')['site_currency_symbol'] : '',
            'payment_sandbox_status' => isset(Cache::get('settings')['payment_sandbox_status']) ? Cache::get('settings')['payment_sandbox_status'] : '',
        ];
        return bind_settings_tab_content('payment', 'Invoice::_form_payment_settings', trans('Invoice::invoice.settings.content.update'), $data);
    }

}