@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Invoice::invoice.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Invoice::invoice.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('invoice.list') }}"><i class="fa fa-laptop"></i>{{ trans('Invoice::invoice.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Invoice::invoice.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    @roles(['1'])
                    <a href="{{ route('invoice.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Invoice::invoice.buttons.create') }}
                        </button>
                    </a>
                    @endroles
                    <table id="invoices-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th class="">{{ trans('Invoice::invoice.inputs.id') }}#</th>
                            <th class="col-sm-1">{{ trans('Invoice::invoice.inputs.serial') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.client') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.create_date') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.due_date') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.grand_total') }}</th>
                            <th>{{ trans('Invoice::invoice.inputs.payment_status') }}</th>
                            <th>{{ trans('Invoice::invoice.columns.action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#invoices-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("invoice.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'serial', name: 'serial'},
                {data: 'client', name: 'client'},
                {data: 'create_date', name: 'create_date'},
                {data: 'due_date', name: 'due_date'},
                {data: 'grand_total', name: 'grand_total'},
                {data: 'payment_status', name: 'payment_status'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            order: [[0, "desc"]],
            searchDelay: 500

        });
        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();

    });
</script>
@endpush