@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Invoice::invoice.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Invoice::invoice.optional_title.view') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('invoice.list') }}"><i class="fa fa-laptop"></i>{{ trans('Invoice::invoice.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Invoice::invoice.breadcrumb.second') }}</li>
@endsection


@section('moduleContent')
    <div class="col-lg-12">
        <div class="box">
            <div class="box-body">
                <div class="form-group col-lg-12">
                    <label for="global_url" class="">Global Access Url</label>
                    <input class="form-control" name="global_url" id="global_url" type="text" value="{!!  route('invoice.global', [$invoice->serial,$invoice->token]) !!}">
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12">
        @if ($errors->any())
            @foreach ($errors->all() as $error)
                <div class="alert alert-danger" >
                    {!! $error !!}
                </div>
            @endforeach
        @endif
        <!-- Box Comment -->
        <div class="box">
            <div class="box-header">
                <section class="content-header">
                    <h1 class="box-title">
                        @yield('moduleTitle', 'New Monule')
                        <small>@yield('moduleDescription', 'Optional description')</small>
                    </h1>
                </section>
                <!-- /.user-block -->
                <div class="box-tools hidden-xs">
                    @role('Admin')
                    <a href="{{ route('invoice.edit', $invoice->id) }}">
                        <button type="button" class="btn btn-flat margin-bottom pull-right bg-blue" data-toggle="tooltip" title="{{ trans('Invoice::invoice.optional_title.edit') }}">
                            <i class="fa fa-pencil"></i> {{ trans('Invoice::invoice.optional_title.edit') }}
                        </button>
                    </a>
                    @endrole
                    <button type="button" class="btn btn-flat margin-bottom pull-right btn-info" data-toggle="modal" data-target="#paymentHistory" title="Payment History">
                        <i class="fa fa-info"></i> {{ trans('Invoice::invoice.buttons.payment_history') }}
                    </button>
                    <button type="button" class="btn btn-flat margin-bottom bg-olive pull-right" data-toggle="modal" data-target="#sendEmail"  title="Send Email">
                        <i class="fa fa-envelope"></i> {{ trans('Invoice::invoice.buttons.send_email') }}</button>

                    <a href="{!!  route('invoice.global', [$invoice->serial,$invoice->token]) !!}" target="_blank" class="btn btn-flat margin-bottom bg-maroon pull-right" title="Print Preview">
                        <i class="fa fa-envelope"></i> {{ trans('Invoice::invoice.buttons.print_preview') }}</a>

                    @if($invoice->payment_status != "paid")
                    <button type="button" class="btn btn-flat margin-bottom btn-success pull-right" data-toggle="modal" data-target="#myModal"  title="Payment">
                        <i class="fa fa-credit-card"></i> {{ trans('Invoice::invoice.buttons.submit_payment') }}</button>
                    @endif
                </div>
                <!-- /.box-tools -->
            </div><!-- /.box-header -->
            <!-- /.box-header -->
            <div class="box-body">
                <!-- Invoice content -->
                <section class="invoice">
                    <!-- title row -->
                    <div class="row">
                        <div class="col-xs-12">
                            <h2 class="page-header">
                                <i class="fa fa-globe"></i> {{ isite()->siteName() }}
                                <small class="pull-right">Date: {{ date('Y-m-d') }}</small>
                            </h2>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- info row -->
                    <div class="row invoice-info">
                        <div class="col-sm-4 invoice-col">
                            <h4>{{ trans('Invoice::invoice.view.from') }}</h4>
                            <address>
                                <strong>{{ isite()->siteName() }}</strong><br>
                                {{ $invoice->user->name }}<br>
                                {{ isite()->sitePhone() }}<br>
                                {{ isite()->siteAddress() }}<br>
                                {{ isite()->siteCity().', '.isite()->siteState().', '.isite()->siteCountry() }}<br>
                                {{ isite()->siteEmail() }}
                            </address>
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-4 invoice-col">
                            <h4>{{ trans('Invoice::invoice.view.to') }}</h4>
                            <address>
                                <strong>{{ $client->name }}</strong><br>
                                @if(isset($company->company)){{ $company->company }}<br>@endif
                                @if($company->phone){{ $company->phone }}<br>@endif
                                {{ $company->address_line_one. ', '. $company->address_line_two }}<br>
                                {{ $company->city. ', '. $company->state.', '.$company->zip_code.', '.$company->country }}<br>
                                {{ $client->email }}
                            </address>
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-4 invoice-col">
                            <h4>{{ trans('Invoice::invoice.view.info') }}</h4>
                            <b>{{ trans('Invoice::invoice.inputs.invoice_no') }} #{{ $invoice->serial }}</b><br>
                            <b>{{ trans('Invoice::invoice.inputs.order_id') }}:</b> {{ $invoice->id }}<br>
                            <b>{{ trans('Invoice::invoice.inputs.payment_type') }}:</b> <button class="btn btn-info btn-xs">{{ $invoice->paymenttype->name }}</button><br>
                            <b>{{ trans('Invoice::invoice.inputs.due_date') }}:</b> {{ Carbon\Carbon::parse($invoice->due_date)->format('jS F Y ') }}<br>
                            <b>{{ trans('Invoice::invoice.inputs.payment_status') }}:</b> <button class="btn btn-info btn-xs">{{ $invoice->payment_status }}</button><br>
                            <br>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->

                    <!-- Table row -->
                    <div class="row">
                        <div id="hide-table">
                            <div class="col-xs-12 table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                    <tr>
                                        <th data-title="{{ trans('Invoice::invoice.table.name') }}">{{ trans('Invoice::invoice.table.name') }}</th>
                                        <th data-title="{{ trans('Invoice::invoice.table.amount') }}">{{ trans('Invoice::invoice.table.amount') }}</th>
                                        <th data-title="{{ trans('Invoice::invoice.table.quantity') }}">{{ trans('Invoice::invoice.table.quantity') }}</th>
                                        <th data-title="{{ trans('Invoice::invoice.table.subtotal') }}">{{ trans('Invoice::invoice.table.subtotal') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($invoice->products as $product)
                                        <tr>
                                            <td data-title="{{ trans('Invoice::invoice.table.name') }}" class="table-name">{{$product->name}}</td>
                                            <td  data-title="{{ trans('Invoice::invoice.table.amount') }}" class="table-price">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->price, 2)}}</td>
                                            <td  data-title="{{ trans('Invoice::invoice.table.quantity') }}" class="table-qty">{{$product->quantity}}</td>
                                            <td data-title="{{ trans('Invoice::invoice.table.subtotal') }}" class="table-total text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->quantity * $product->price, 2)}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.col -->
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            @if($invoice->payment_status=="paid")
                                <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/paid.png') }}" alt="paid" width="250" height="150" >
                            @elseif($invoice->payment_status=="unpaid")
                                <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/unpaid.png') }}" alt="unpaid" width="250" height="150" >
                            @elseif($invoice->payment_status=="canceled")
                                <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/canceled.png') }}" alt="canceled" width="250" height="150" >
                            @elseif($invoice->payment_status=="partially paid")
                                <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/due.png') }}" alt="paid" width="250" height="150" >
                            @elseif($invoice->payment_status=="pending")
                                <img style="margin:20px 0 20px 20px;" src="{{ url('public/assets/invoice/img/due.png') }}" alt="paid" width="250" height="150" >
                            @endif
                        </div>
                        <div class="col-lg-6">
                            <table class="table table-bordered">
                                <tfoot>
                                <tr>
                                    <th class="table-label">{{ trans('Invoice::invoice.table.total') }}</th>
                                    <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->sub_total, 2)}}</td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Invoice::invoice.table.discount') }}</th>
                                    <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->discount, 2)}}</td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Invoice::invoice.table.tax') }}</th>
                                    <td class="table-amount text-right">
                                        @if(isset($tax))
                                            @if($tax->type == 1)
                                                %
                                            @else
                                                {{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}
                                            @endif
                                            {{$tax->rate}}
                                        @else
                                            0.00
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Invoice::invoice.inputs.paid_amount') }}</th>
                                    <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->payments->sum('paid_amount'),2)}}</td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Invoice::invoice.table.due_amount') }}</th>
                                    <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->grand_total - $invoice->payments->sum('paid_amount'), 2)}}</td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Invoice::invoice.table.grand_total') }}</th>
                                    <td class="table-amount text-right">{{ $invoice->currency->currency_symbol ? $invoice->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($invoice->grand_total, 2) }}</td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <!-- /.row -->

                    <div class="row">
                        <!-- accepted payments status -->
                        <div class="col-xs-12">
                            <p class="lead">{{ trans("Invoice::invoice.inputs.note") }}:</p>
                            <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                                {{ $invoice->note }}
                            </p>
                            <p class="lead">{{ trans("Invoice::invoice.inputs.terms_conditions") }}:</p>
                            <p class="text-muted well well-sm no-shadow">
                                @if(isset($invoice->terms_conditions)){{ $invoice->terms_conditions }}<br>@endif
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 pull-right">
                            @if($invoice->payment_status != "paid")
                                <button type="button" class="btn btn-success pull-right" data-toggle="modal" data-target="#myModal"><i class="fa fa-credit-card"></i> {{ trans('Invoice::invoice.buttons.submit_payment') }}</button>
                            @endif
                            <a class="btn btn-primary pull-right" style="margin-right: 5px;" href="{{ route('invoice.pdf', $invoice) }}">
                                <i class="fa fa-download"></i> {{ trans('Invoice::invoice.buttons.generate_pdf') }}
                            </a>
                        </div>
                    </div>
                    <!-- /.row -->
                </section>
                <!-- Invoice section end -->
            </div>
        </div>
    </div>
    <div class="clearfix"></div>

    {{-- Payment Modal --}}
    <div class="modal fade" id="myModal" role="dialog">
        <div class="modal-dialog ">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">{{ trans('Invoice::invoice.inputs.invoice_no') }} #{{$invoice->serial}}</h4>
                </div>
                {!! Form::open(['method' => 'POST','route' => ['invoice.payment', $invoice->id], 'id' => 'paymentForm', 'class' => 'form-horizontal']) !!}
                <div class="modal-body">
                    <div class="form-group">
                        {!! Form::label('total', trans('Invoice::invoice.inputs.grand_total'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::text('grand_total', number_format($invoice->grand_total, 2), ['class' => 'form-control', 'disabled' => true]) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('paying_amount', trans('Invoice::invoice.inputs.paying_amount'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::text('paying_amount', number_format($invoice->grand_total - $invoice->payments->sum('paid_amount'), 2, '.', ''), ['class' => 'form-control']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('paid_date', trans('Invoice::invoice.inputs.paid_date'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::text('paid_date', date('Y-m-d'), ['class' => 'form-control', 'id' => 'paid_date']) !!}
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('payment_option', trans('Invoice::invoice.inputs.payment_type'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            <select class="form-control" name="payment_option" id="payment_option" onchange="CheckType()">
                                <option value="">{{ trans('Invoice::invoice.inputs.select_payment_type') }}</option>
                                @foreach($payment_types as $key => $type)
                                    @role("Client")
                                        <?php if(strtolower($type) == "paypal" || strtolower($type) == "stripe" || strtolower($type) == "2checkout") { ?>
                                            <option value="{{ strtolower($type) }}"> {{ $type }} </option>
                                        <?php } ?>
                                    @endnotrole
                                    @notrole("Client")
                                        <option value="{{ strtolower($type) }}"> {{ $type }} </option>
                                    @endnotrole
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div id="bankOption" style="display: none;">
                        <div class="form-group">
                            {!! Form::label('bank_id', trans('Invoice::invoice.inputs.bank_id'), ['class' => 'col-lg-4 control-label']) !!}
                            <div class="col-lg-8">
                                <select name="bank_id" id="bank_id" class="form-control">
                                    <option value="">Select Bank Account</option>
                                    @foreach($banks as $key => $bank)
                                        <option value="{{$key}}">{{$bank}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div id="cardOption" style="display: none;">
                        <div class="form-group">
                            {!! Form::label('card_number', trans('Invoice::invoice.inputs.card_number'), ['class' => 'col-lg-4 control-label']) !!}
                            <div class="col-lg-8">
                                {!! Form::text('card_number', null, ['class' => 'form-control']) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            {!! Form::label('name', trans('Invoice::invoice.inputs.name_on_card'), ['class' => 'col-lg-4 control-label']) !!}
                            <div class="col-lg-8">
                                {!! Form::text('name', null, ['class' => 'form-control']) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            {!! Form::label('billing_address', trans('Invoice::invoice.inputs.billing_address'), ['class' => 'col-lg-4 control-label']) !!}
                            <div class="col-lg-8">
                                {!! Form::text('billing_address', null, ['class' => 'form-control']) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            {!! Form::label('cvv', trans('Invoice::invoice.inputs.cvv'), ['class' => 'col-lg-4 control-label']) !!}
                            <div class="col-lg-8">
                                {!! Form::text('cvv', null, ['class' => 'form-control']) !!}
                            </div>
                        </div>
                        <div class="form-group">
                            {!! Form::label('expire_month', trans('Invoice::invoice.inputs.expire'), ['class' => 'col-lg-4 control-label']) !!}
                            <div class="col-xs-4">
                                {!! Form::text('expire_month', null, ['class' => 'form-control col-lg-4', 'id' => 'expire_month']) !!}
                            </div>
                            <div class="col-xs-4">
                                {!! Form::text('expire_year', null, ['class' => 'form-control col-lg-4', 'id' => 'expire_year']) !!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('Invoice::invoice.inputs.close') }}</button>
                    <button type="submit" class="btn btn-success" id="paymentSubmit">{{ trans('Invoice::invoice.inputs.proceed') }}</button>
                </div>
                {!!  Form::close()  !!}
            </div>

        </div>
    </div>
    <!-- /.Payment-modal -->
    {{-- Payment history Modal --}}
    <div class="modal fade" id="paymentHistory" role="dialog">
        <div class="modal-dialog modal-lg">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">{{ trans('Invoice::invoice.inputs.invoice_no') }} #{{$invoice->serial}}</h4>
                </div>
                <div class="modal-body">
                    <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ trans('Invoice::invoice.columns.payment_by') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.payment_type') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.transaction_id') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.currency') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.paid_amount') }}</th>
                                    <th>{{ trans('Invoice::invoice.columns.payment_date') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($invoice->payments as $payment)
                                    <tr>
                                        <td>{{ $payment->id }}</td>
                                        <td>{{ $payment->user->name }}</td>
                                        <td>{{ $payment->payment_type }}</td>
                                        <td>{{ $payment->transaction_id }}</td>
                                        <td>{{ $payment->currency_code }}</td>
                                        <td>{{ $payment->paid_amount }}</td>
                                        <td>{{ Carbon\Carbon::parse($payment->paid_date)->format('jS F Y ') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
                </div>
            </div>

        </div>
    </div>
    <!-- /.payment history -modal -->
    {{-- Payment history Modal --}}
    <div class="modal fade" id="sendEmail" role="dialog">
        <div class="modal-dialog ">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">{{ trans('Invoice::invoice.inputs.invoice_no') }} #{{$invoice->serial}}</h4>
                </div>
                {!! Form::open(['method' => 'POST','route' => ['invoice.send.email', $invoice->id], 'id' => 'sendEmailForm', 'class' => 'form-horizontal']) !!}
                <div class="modal-body">
                    <div class="form-group">
                        {!! Form::label('Email', trans('Invoice::invoice.inputs.email'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::text('email', $client->email, ['class' => 'form-control', 'id' => 'email']) !!}
                            <span class="email-error text-danger"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('Email Template', trans('Invoice::invoice.inputs.email_template'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::select('email_template', [''=>'Select Template']+$email_templates, null, ['class' => 'form-control', 'id' => 'email_template']) !!}
                            <span class="email_template-error text-danger"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('subject', trans('Invoice::invoice.inputs.subject'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::text('subject', null, ['class' => 'form-control', 'id' => 'subject']) !!}
                            <span class="subject-error text-danger"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('body', trans('Invoice::invoice.inputs.message'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::textarea('body', null, ['class' => 'form-control', 'cols' => '30', 'rows' => '5', 'id' => 'body']) !!}
                            <span class="body-error text-danger"></span>
                        </div>
                    </div>

                    <div class="form-group">
                        {!! Form::label('attachStatus', trans('Invoice::invoice.inputs.attachStatus'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::checkbox('attachStatus', true, ['class' => 'form-control']) !!}
                            <span class="attachStatus-error text-danger"></span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans("Invoice::invoice.inputs.close") }}</button>
                    <button type="submit" class="btn btn-success" id="send-email">{{ trans("Invoice::invoice.inputs.send_email") }}</button>
                </div>
                {!!  Form::close()  !!}
            </div>

        </div>
    </div>
    <!-- /.payment history -modal -->
@endsection

@push('headerAssetPush')
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
<link rel="stylesheet" href="{{ url('bassets/plugins/datepicker/datepicker3.css') }}">
<link rel="stylesheet" href="{{ url('bassets/plugins/editor/jquery-te-1.4.0.css') }}">
<style>
    .invoice {
        font-size: 16px;
    }
</style>
@endpush

@push('footerAssetPush')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script src="{{ url('bassets/plugins/editor/jquery-te-1.4.0.min.js') }}"></script>
<script src="{{ url('bassets/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
<script>
    $('#paid_date').datepicker({
        format: 'yyyy-mm-dd',
        setDate: new Date(),
        autoclose: true
    });
    $('#paymentForm').submit(function () {
        var payment_option = $.trim($('#payment_option').val());
        var paying_amount = $.trim($('#paying_amount').val());
        var due_amount = "{{ $invoice->grand_total - $invoice->payments->sum('paid_amount') }}";
        if (parseInt(paying_amount) >  parseInt(due_amount)) {
            alert("Paying amount can't be more then due amount");
            return false;
        }
        // Check if empty of not
        if (payment_option  === '') {
            alert('Payment Option is empty.');
            return false;
        } else if(paying_amount === '') {
            alert('Paying amount is empty.');
            return false;
        } else if(payment_option=='stripe') {
            var card_number = $.trim($('#card_number').val());
            var cvv = $.trim($('#cvv').val());
            var expire_month = $.trim($('#expire_month').val());
            var expire_year = $.trim($('#expire_year').val());
            if (card_number === '' || cvv === '' || expire_month === '' || expire_year === '') {
                alert('Card Information is empty!');
                return false;
            }
            return true;
        } else if(payment_option=='bank') {
            var bank_id = $.trim($('#bank_id').val());
            if (bank_id === '') {
                alert('Please select bank account');
                return false;
            }
            return true;
        } else {
            return true;
        }
    });

    $(function(){
        $('#sendEmailForm').on('submit',function(e){
            $.ajaxSetup({
                header:$('meta[name="_token"]').attr('content')
            })
            e.preventDefault(e);

            $.ajax({

                type:"POST",
                url:'{{ route('invoice.send.email', $invoice->id) }}',
                data:$(this).serialize(),
                dataType: 'json',
                success: function(data){
                    console.log(data);
                    $('#sendEmail').modal('hide');
                    toastr.success("Success!");
                },
                error: function(data){
                    if (data.responseJSON) {
                        if (data.responseJSON.body) {
                            $('.body-error').html(data.responseJSON.body);
                        } else {
                            $('.body-error').html("");
                        }
                        if (data.responseJSON.subject) {
                            $('.subject-error').html(data.responseJSON.subject);
                        } else {
                            $('.subject-error').html("");
                        }
                        if (data.responseJSON.email) {
                            $('.email-error').html(data.responseJSON.email);
                        } else {
                            $('.email-error').html("");
                        }
                    } else {
                        $('#sendEmail').modal('hide');
                        toastr.error("Please Configure your smtp settings");
                    }
                }
            })
        });
    });

    function CheckType() {
        var payment_option = $('#payment_option').val();
        if (payment_option=="stripe") {
            $('#cardOption').show();
        } else if(payment_option=="bank"){
            $('#cardOption').hide();
            $('#bankOption').show();
        } else{
            $('#cardOption').hide();
            $('#bankOption').hide();
        }
    }
    $("#expire_month").datepicker( {
        format: "mm",
        viewMode: "months",
        minViewMode: "months"
    });
    $("#expire_year").datepicker( {
        format: "yyyy",
        viewMode: "years",
        minViewMode: "years"
    });

    $(document).ready(function() {
        $('#body').jqte();
    });
    $( document ).ready(function() {
        $("#email_template").change(function() {
            var template_id = $(this).val();
            var invoice_id = "{{ $invoice->id }}";
            var url = '{{ route("invoice.get.emailTemplate") }}';
            if (template_id=="") {
                $('.jqte_editor').html("");
            } else {
                $.ajax({
                    type:"GET",
                    url:url,
                    data: {template_id: template_id, invoice_id: invoice_id},
                    dataType: 'html',
                    success: function(data){
                        $('.jqte_editor').html(data);
                        console.log(data);
                    },
                    error: function(data){
                        toastr.error(data);
                    }
                })
            }

        });
    });
</script>
@endpush
