<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Invoice', 'prefix' => 'admin/invoice', 'namespace' => '\Modules\Invoice\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'InvoiceController@index')->name('invoice.list');
    Route::get('list', 'InvoiceController@invoiceDataTable')->name('invoice.list.datatable');

    Route::get('add', 'InvoiceController@add')->name('invoice.create');
    Route::post('add', 'InvoiceController@store')->name('invoice.create.post');

    Route::get('edit/{invoice}', 'InvoiceController@edit')->name('invoice.edit');
    Route::put('edit/{invoice}', 'InvoiceController@update')->name('invoice.edit.post');

    Route::delete('delete/{invoice}', 'InvoiceController@delete')->name('invoice.destroy');
    Route::get('view/{id}', 'InvoiceController@view')->name('invoice.view');

    Route::get('/get_tax/{tax_id}', function($tax_id)
    {
        $tax = \Modules\Tax\Models\Tax::findOrFail($tax_id);
        if ($tax) {
            return response()
                ->json([
                    'rate' => $tax->rate,
                    'type' => $tax->type
                ], 200);
        } else {
            return response()
                ->json([
                    'rate' => 0,
                    'type' => 1
                ], 200);
        }
    })->name('invoice.get_tax');

//    Payment routes
    Route::post('payment/{invoice}','InvoiceController@payment')->name('invoice.payment');
    Route::get('{invoice}/paypal/success','InvoiceController@getPaypalSuccess')->name('invoice.paypal.success');
    Route::get('{invoice}/paypal/cancel','InvoiceController@getPaypalCancel')->name('invoice.paypal.cancel');
    Route::get('{invoice}/twocheckout/success','InvoiceController@getTwoCheckoutSuccess')->name('invoice.twocheckout.success');
    Route::get('{invoice}/twocheckout/cancel','InvoiceController@getTwoCheckoutCancel')->name('invoice.twocheckout.cancel');
    Route::get('{invoice}/payu/success','InvoiceController@getPayUSuccess')->name('invoice.payu.success');
    Route::get('{invoice}/payu/cancel','InvoiceController@getPayUCancel')->name('invoice.payu.cancel');

    Route::post('send/{invoice}','InvoiceController@sendEmail')->name('invoice.send.email');

    Route::patch('payment/settings', 'InvoiceController@updatePaymentSettings')->name('payment.settings.update');
    Route::get('pdf/{id}', 'InvoiceController@invoicePdf')->name('invoice.pdf');

    // Payment history
    Route::get('payments', 'InvoiceController@paymentsList')->name('payment.list');
    Route::get('payments/list', 'InvoiceController@paymentsListDataTable')->name('payments.list.datatable');

    // Email Template
    Route::get('email/template', 'InvoiceController@emailTemplate')->name('invoice.get.emailTemplate');

});

Route::group(['Module' => 'Invoice', 'prefix' => '', 'namespace' => '\Modules\Invoice\Controllers', 'middleware' => ['web', 'installer']], function() {
    Route::get('invoice/{serial}/{token}', 'InvoiceController@globalAccess')->name('invoice.global');
    Route::get('invoice/pdf/{serial}/{token}', 'InvoiceController@globalPdf')->name('invoice.global.pdf');
});
