<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Notice\Listeners\History;

/**
 * Class UserEventHistoryListener
 * @package Modules\Notice\Listeners\Notice
 */
class NoticeEventHistoryListener
{
	/**
	 * @var string
	 */
	private $history_slug = 'Notice';

	/**
	 * @param $event
	 */
	public function onCreated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.notices.created") <strong>'.$event->notice->title.'</strong>',
			$event->notice->id,
			'plus',
			'bg-green'
		);

	}

	/**
	 * @param $event
	 */
	public function onUpdated($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.notices.updated") <strong>'.$event->notice->title.'</strong>',
            $event->notice->id,
			'save',
			'bg-aqua'
		);
	}

	/**
	 * @param $event
	 */
	public function onDeleted($event) {
		history()->log(
			$this->history_slug,
			'trans("history.backend.notices.deleted") <strong>'.$event->notice->title.'</strong>',
            $event->notice->id,
			'trash',
			'bg-maroon'
		);
	}

	/**
	 * Register the listeners for the subscriber.
	 *
	 * @param  \Illuminate\Events\Dispatcher  $events
	 */
	public function subscribe($events)
	{
        $events->listen(
            \Modules\Notice\Events\History\NoticeCreated::class,
            'Modules\Notice\Listeners\History\NoticeEventHistoryListener@onCreated'
        );

        $events->listen(
            \Modules\Notice\Events\History\NoticeUpdated::class,
            'Modules\Notice\Listeners\History\NoticeEventHistoryListener@onUpdated'
        );

        $events->listen(
            \Modules\Notice\Events\History\NoticeDeleted::class,
            'Modules\Notice\Listeners\History\NoticeEventHistoryListener@onDeleted'
        );

	}
}