<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Notice\Models\Traits\Attribute;

use Auth;

trait NoticeAttribute
{
    public function getEditButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@notice-edit')) {
            return '<a href="' . route('notice.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('Notice::notice.buttons.actions.edit') . '"></i></a> ';
        }
        return '';
    }

    public function getViewButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@notice-view')) {
            return '<a href="' . route('notice.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('Notice::notice.buttons.actions.view') . '"></i></a> ';
        }
        return '';
    }

    public function getDeleteButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@notice-delete')) {
            if ($this->user_id == auth()->id()) {
                return '<a href="' . route('notice.destroy', $this) . '"
                 data-method="delete"
                 data-trans-button-cancel="Cancel"
                 data-trans-button-confirm="Delete"
                 data-trans-title="Are you sure?"
                 class="btn btn-xs btn-danger notice-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('Notice::notice.buttons.actions.delete') . '"></i></a> ';
            }
        }

        return "";
    }

    public function getActionButtonsAttribute()
    {
        return
            $this->getViewButtonAttribute().
            $this->getEditButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}