@push('headerAssetPush')
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet" href="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css') }}">
@endpush

@push('footerAssetPush')
<!-- Bootstrap WYSIHTML5 -->
<script src="{{ url('bassets/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js') }}"></script>
<script type="application/javascript">
    $(".textarea").wysihtml5();
</script>
@endpush

@if ($formFor == 'create')
    {!! Form::open(['class' => 'form-horizontal']) !!}
@elseif ($formFor == 'edit')
    {!! Form::model($notice, [
        'method' => 'PATCH',
        'route' => ['notice.edit', $notice->id],
        'class' => 'form-horizontal'
    ]) !!}
@endif
<div class="box-body">
    <div class="form-group{{ $errors->has('title') ? ' has-error' : '' }}">
        {!! Form::label('title', trans('Notice::notice.inputs.one'), ['class' => 'col-lg-2 control-label']) !!}
        <div class="col-lg-6">
            {!! Form::text('title', null, ['class' => 'form-control', 'required' => 'required']) !!}
            {!! $errors->first('title', '<span class="help-block">:message</span>') !!}
        </div>
    </div>

    <div class="form-group{{ $errors->has('body') ? ' has-error' : '' }}">

        {!! Form::label('body', trans('Notice::notice.inputs.two'), ['class' => 'col-lg-2 control-label']) !!}

        <div class="col-lg-6">
            {!! Form::textarea('body', null, ['class' => 'form-control textarea', 'required' => 'required']) !!}
            {!! $errors->first('body', '<span class="help-block">:message</span>') !!}
        </div>
    </div>


</div>
<div class="box box-info">
    <div class="box-body">
        <div class="form-group">
            <div class="col-sm-4 col-sm-offset-2">
                {{ link_to_route('notice.list', trans('Notice::notice.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
            </div>
        </div>
        <div class="clearfix"></div>
    </div><!-- /.box-body -->
</div><!--box-->
{{ Form::close() }}