@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-bell"></i> {{ trans('Notice::notice.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Notice::notice.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('notice.list') }}"><i class="fa fa-bell"></i>{{ trans('Notice::notice.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Notice::notice.breadcrumb.list') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    {{--@roles([1])--}}
                    @permission('admin@notice-add')
                    <a href="{{ route('notice.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Notice::notice.buttons.create') }}
                        </button>
                    </a>
                    @endpermission
                    {{--@endroles--}}
                    <div id="hide-table">
                        <table id="notices-table" class="table table-striped table-bordered table-hover no-footer">
                            <thead>
                            <tr>
                                <th class="col-sm-1">#</th>
                                <th>{{ trans('Notice::notice.columns.one') }}</th>
                                <th>{{ trans('Notice::notice.columns.two') }}</th>
                                <th class="col-lg-2">{{ trans('Notice::notice.columns.three') }}</th>
                                <th class="col-lg-2">{{ trans('Notice::notice.columns.four') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script type="application/javascript">
    $(function() {
        var t = $('#notices-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("notice.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'title', name: 'title'},
                {data: 'body', name: 'body'},
                {data: 'users', name: 'users'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            order: [[0, "desc"]],
            searchDelay: 500

        });

        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();
    });
</script>
@endpush