@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-bell"></i> {{ trans('Notice::notice.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Notice::notice.optional_title.view') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('notice.list') }}"><i class="fa fa-bell"></i>{{ trans('Notice::notice.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Notice::notice.breadcrumb.view') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <dl class="dl-horizontal">
                        <dt>{{ trans('Notice::notice.columns.one') }}</dt>
                        <dd>{{ $notice->title }}</dd>
                        <dt>{{ trans('Notice::notice.columns.two') }}</dt>
                        <dd>{!! $notice->body !!}</dd>
                        <dt>{{ trans('Notice::notice.inputs.three') }}</dt>
                        <dd>{{ $notice->created_at->toDayDateTimeString() }}</dd>
                        <dt>{{ trans('Notice::notice.columns.three') }}</dt>
                        <dd>{{ $notice->user->name }}</dd>
                    </dl>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection
