<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(array('Module' => 'Notice', 'prefix' => 'admin', 'namespace' => '\Modules\Notice\Controllers', 'middleware' => ['web', 'auth', 'acl']), function() {


    Route::group(['prefix' => 'notice'], function () {
        Route::get('/', 'NoticeController@index')->name('notice.list');
        Route::get('list', 'NoticeController@noticeDataTable')->name('notice.list.datatable');

        Route::get('add', 'NoticeController@add')->name('notice.create');
        Route::post('add', 'NoticeController@create')->name('notice.create.post');

        Route::get('edit/{notice}', 'NoticeController@edit')->name('notice.edit');
        Route::patch('edit/{notice}', 'NoticeController@update')->name('notice.edit.post');

        Route::delete('delete/{notice}', 'NoticeController@delete')->name('notice.destroy');
        Route::get('view/{notice}', 'NoticeController@show')->name('notice.view');

    });

});


Route::group(array('Module' => 'Notice', 'prefix' => 'admin/notice', 'namespace' => '\Modules\Notice\Controllers', 'middleware' => ['web', 'auth' ]), function() {

    Route::get('button/click/', function () {
        Session::put( 'notice-button-click', false );
    })->name('notice.button.click');

    Route::get('shipu', function () {
//        session()->forget('notice-button-click');
        dd(Session::get( 'notice-button-click'));
    });

});
