<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\PaymentType\Models\Traits\Attribute;

use Illuminate\Support\Facades\Auth;

trait PaymentTypeAttribute
{
    public function getEditButtonAttribute()
    {
        if (strtolower($this->name) != "paypal" && strtolower($this->name) != "stripe" && strtolower($this->name) != "2checkout" && strtolower($this->name) != "bank") {
            if (Auth::user()->hasPermission('admin@type-payment-edit')) {
                return '<a href="' . route('paymenttype.edit', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="' . trans('PaymentType::paymenttype.buttons.actions.edit') . '"></i></a> ';
            }
        }
        return '';
    }

    public function getViewButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@type-payment-view')) {
            return '<a href="' . route('paymenttype.view', $this) . '" class="btn btn-xs btn-primary"><i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="' . trans('PaymentType::paymenttype.buttons.actions.view') . '"></i></a> ';
        }
        return '';
    }

    public function getStatusButtonAttribute()
    {
        if(Auth::user()->hasPermission('admin@type-payment-status')) {
            if ($this->status == 0)
                return "<a id=\"status\" class=\"btn btn-success btn-xs\" href=" . route('paymenttype.status', $this) . " title='" . trans('PaymentType::paymenttype.buttons.actions.status.active') . "'><i class='fa fa-play'></i></a> ";
            else
                return "<a id=\"status\" class=\"btn btn-danger btn-xs\" href=" . route('paymenttype.status', $this) . " title='" . trans('PaymentType::paymenttype.buttons.actions.status.deactive') . "'><i class='fa fa-pause'></i></a> ";
        }

    }

    public function getDeleteButtonAttribute()
    {
        if (strtolower($this->name) != "paypal" && strtolower($this->name) != "stripe" && strtolower($this->name) != "2checkout" && strtolower($this->name) != "bank") {
            if (Auth::user()->hasPermission('admin@type-payment-delete')) {
                if ($this->user_id == auth()->id() || auth()->user()->hasrole(1)) {

                    return '<a href="' . route('paymenttype.destroy', $this) . '"
                     data-method="delete"
                     data-trans-button-cancel="Cancel"
                     data-trans-button-confirm="Delete"
                     data-trans-title="Are you sure?"
                     class="btn btn-xs btn-danger paymenttype-delete"><i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="' . trans('PaymentType::paymenttype.buttons.actions.delete') . '"></i></a> ';
                }
            }
        }

        return "";
    }

    public function getActionButtonsAttribute()
    {
        return
            $this->getStatusButtonAttribute().
            $this->getEditButtonAttribute().
            $this->getDeleteButtonAttribute();
    }
}