<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Plugin\Controllers;

use App\Http\Controllers\Controller;
use Modules\Plugin\Requests\PluginRequest;
use File, Alert;

class PluginController extends Controller
{

    function __construct()
    {

    }

    public function add()
    {
        if(config('core.demosite')) {
            Alert::warning('Disabled', trans('Core::demo.message'));
            return redirect(route('backend.root'));
        }

        return view("Plugin::pluginCreate");
    }

    public function create(PluginRequest $request)
    {
        if(config('core.demosite')) {
            Alert::warning('Disabled', trans('Core::demo.message'));
            return redirect(route('backend.root'));
        }

        $path   = $request->file('plugin')->store('plugins');
        $zip    = new \ZipArchive();
        $res    = $zip->open(storage_path("/app/").$path);
        if ($res === TRUE) {
            $zip->extractTo(public_path('Modules'));
            $zip->close();

            $exist          = [];
            $getAllFolders  = array_map('class_basename', File::directories(public_path('Modules')));
            foreach ($getAllFolders as $folder) {
                $moduleJson = '';
                $themeJson  = '';
                $pathJson   = '';

                $sourcePath = public_path('Modules/'.$folder); // unzip path
                $forModule  = $sourcePath.'/module.json';
                $forTheme   = $sourcePath.'/theme.json';
                $forPath    = $sourcePath.'/path.json';

                if(file_exists($forModule)) {

                    $moduleJson     = File::get($forModule);
                    $moduleInfo     = json_decode($moduleJson, true);
                    //validation
                    $isDir          = is_dir(base_path('Modules/'.$moduleInfo['name']));

                    if(isset($moduleInfo['overwrite']) && $moduleInfo['overwrite'] == true){
                        $isDir = false;
                    }

                    if( $isDir ) {
                        $exist[] = $moduleInfo['name'].' Module Already Exit';
                    } else {
                        $destinationPath = base_path('Modules/'.$moduleInfo['name']);
                        $success = File::moveDirectory($sourcePath, $destinationPath, true);
                        if($success) {
                            chmod_recursive($destinationPath);
                        }
                        $exist[] = $moduleInfo['name'].' Module Successfully Upload';
                    }

                } elseif(file_exists($forTheme)) {

                    $themeJson      = File::get($forTheme);
                    $themeInfo      = json_decode($themeJson, true);
                    //validation
                    $isDir          = is_dir(base_path('Themes/'.$themeInfo['for'].'/'.$themeInfo['name']));

                    if(isset($themeInfo['overwrite']) && $themeInfo['overwrite'] == true){
                        $isDir = false;
                    }

                    if( $isDir ) {
                        $exist[] = $themeInfo['name'].' Theme Already Exit';
                    } else {
                        $destinationPath = base_path('Themes/'.$themeInfo['for'].'/'.$themeInfo['name']);

                        $success = File::moveDirectory($sourcePath, $destinationPath, true);

                        if($success) {
                            chmod_recursive($destinationPath);
                            $exist[] = $themeInfo['name'].' Theme Successfully Upload';
                        }
                    }

                } elseif (file_exists($forPath)) {
                    $pathJson      = File::get($forPath);
                    $pathInfo      = json_decode($pathJson, true);


                    $getReplaceFolders = array_map('class_basename', File::directories($sourcePath));

                    foreach ($getReplaceFolders as $replaceFolderName) {
                        $newSourcePath      = $sourcePath.'/'.$replaceFolderName;
                        $destinationPath    = base_path($replaceFolderName);

                        $success = File::moveDirectory($newSourcePath, $destinationPath, true);

                        if($success) {
                            chmod_recursive($destinationPath);
                            $exist[] = $folder.'/'.$replaceFolderName.' Folder Successfully Upload';
                        }
                    }

                    $getallFiles = File::glob($sourcePath.'/*.php');
                    foreach ($getallFiles as $file)
                    {
                        $filename           = basename($file, '.php');
                        $destinationPath    = base_path($pathInfo[$filename].'/'.$filename.'.php');

                        $success =File::move($file, $destinationPath);

                        if($success) {
                            chmod_recursive($destinationPath);
                            $exist[] = $filename.'.php File Successfully Upload';
                        }
                    }

                } else {
                    $exist[] = $folder." Extension json file not found";
                }

            }
            $progress  = '<ul>';
            $progress .= '<li>' . implode( '</li><li>', $exist) . '</li>';
            $progress .= '</ul>';

            File::deleteDirectory(public_path('Modules'));
            File::deleteDirectory(storage_path('app/plugins'));

            flash($progress, 'info');
            return redirect()->route('plugin.upload');

        } else {
            Alert::error(trans("Plugin::plugin.alert.error_success"), 'error');
            return redirect()->route('plugin.upload');
        }
    }

}
