<?php
/*
| -------------------------------------------------------------
| iBill - Simplest and Best Billing & Invoice Manager
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net
| -------------------------------------------------------------
| COPYRIGHT:        RESERVED BY INILABS IT
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
namespace Modules\Plugin\Requests;

use App\Http\Requests\Request;

class PluginRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        //$user = Iauth::find($this->segment(3));

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'plugin' => 'required|mimes:zip|max:5000',
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'plugin' => 'required|mimes:zip|max:5000',
                ];
            }
            default:break;
        }
    }
}
