<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/

namespace Modules\Product\Requests;

use App\Http\Requests\Request;

class ProductRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        //$user = Iauth::find($this->segment(3));

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'name' => 'required|max:30|min:3',
                    'note' => 'max:250',
                    'amount' => 'required|numeric|min:0'
                ];
            }
            case 'PUT':
            case 'PATCH':
            {
                return [
                    'name' => 'required|max:30|min:3',
                    'note' => 'max:250',
                    'amount' => 'required|numeric|min:0'
                ];
            }
            default:break;
        }
    }
}
