@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-pinterest-p"></i> {{ trans('Product::product.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Product::product.optional_title.list') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('product.list') }}"><i class="fa fa-pinterest-p"></i>{{ trans('Product::product.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Product::product.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div><!-- /.box-header -->
                <div class="box-body">
                    {{--@roles([1])--}}
                    <a href="{{ route('product.create') }}">
                        <button type="button" class="btn btn-flat margin-bottom" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-plus"></i>
                            {{ trans('Product::product.buttons.create') }}
                        </button>
                    </a>
                    {{--@endroles--}}
                    <table id="products-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ trans('Product::product.columns.name') }}</th>
                            <th>{{ trans('Product::product.columns.amount') }}</th>
                            <th>{{ trans('Product::product.columns.note') }}</th>
                            <th>{{ trans('Product::product.columns.action') }}</th>
                        </tr>
                        </thead>
                    </table>
                </div><!-- /.box-body -->
            </div><!-- /.box -->
        </div>
    </div>

@endsection


@push('footerAssetPush')
<script>
    $(function() {
        var t = $('#products-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("product.list.datatable") }}',
            buttons: [
                'csv', 'excel', 'pdf', 'print', 'reset', 'reload'
            ],
            columns: [
                {data: 'id', name: 'id'},
                {data: 'name', name: 'name'},
                {data: 'amount', name: 'amount'},
                {data: 'note', name: 'note'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
            ],
            order: [[0, "asc"]],
            searchDelay: 500

        });

        t.on( 'order.dt search.dt', function () {
            t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
                cell.innerHTML = i+1;
            } );
        } ).draw();
    });
</script>
@endpush