<?php

namespace Modules\Quotation\Models\Traits\Relationship;



use Modules\Client\Models\Client;
use Modules\Currency\Models\Currency;
use Modules\Quotation\Models\QuotationItem;
use Modules\Quotation\Models\Payment;
use Modules\PaymentType\Models\PaymentType;
use Modules\Tax\Models\Tax;

trait QuotationRelationship
{
    public function user()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
    public function client()
    {
        return $this->belongsTo(config('auth.providers.users.model'));
    }
    public function products()
    {
        return $this->hasMany(QuotationItem::class);
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

}
