<?php

namespace Modules\Quotation\Requests;

use App\Http\Requests\Request;

class QuotationRequest extends Request
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
      

        switch($this->method())
        {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'client_id' => 'required',
                    'currency_id' => 'required',
                    'serial' => 'required',
                    'discount' => 'numeric',
                    'note' => 'max:250',
                    'terms_conditions' => 'max:250',
                    'products.*.name' => 'required|max:255',
                    'products.*.price' => 'required|numeric|min:1',
                    'products.*.quantity' => 'required|integer|min:1'
                ];
            }
            case 'PUT':
            {
                return [
                    'client_id' => 'required',
                    'currency_id' => 'required',
                    'serial' => 'required',
                    'discount' => 'numeric',
                    'note' => 'max:250',
                    'terms_conditions' => 'max:250',
                    'products.*.name' => 'required|max:255',
                    'products.*.price' => 'required|numeric|min:1',
                    'products.*.quantity' => 'required|integer|min:1'
                ];
            }
            case 'PATCH':
            {
                return [
                    'client_id' => 'required',
                    'currency_id' => 'required',
                    'serial' => 'required',
                    'discount' => 'numeric',
                    'note' => 'max:250',
                    'terms_conditions' => 'max:250',
                    'products.*.name' => 'required|max:255',
                    'products.*.price' => 'required|numeric|min:1',
                    'products.*.quantity' => 'required|integer|min:1'
                ];
            }
            default:break;
        }
    }
}
