@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Quotation::quotation.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Quotation::quotation.optional_title.edit') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('quotation.list') }}"><i class="fa fa-laptop"></i>{{ trans('Quotation::quotation.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Quotation::quotation.breadcrumb.second') }}</li>
@endsection

@section('moduleContent')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-success">
                <div class="box-header with-border">
                    <section class="content-header">
                        <h1 class="box-title">
                            @yield('moduleTitle', 'New Monule')
                            <small>@yield('moduleDescription', 'Optional description')</small>
                        </h1>
                        <ol class="breadcrumb">
                            @yield('moduleBreadcrumb', '
                                 <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                 <li class="active">Here</li>
                            ')
                        </ol>
                    </section>
                </div>
                {{--@include('Quotation::_form', ['submitButton' => trans('Quotation::quotation.buttons.add'), 'formFor' => 'create'])--}}
                <div id="invoice">
                    <div v-cloak>
                        <a class="hidden" id="route" href="{{route('quotation.edit', $quotation)}}" ></a>
                        <a class="hidden" id="taxRate" href="{{route('quotation.get_tax', null)}}" ></a>
                        @include('Quotation::_form')
                        <div class="box-footer">
                            <a href="{{route('quotation.list')}}" class="btn btn-default">{{ trans('Quotation::quotation.buttons.cancel') }}</a>
                            <button class="btn btn-success" @click="update('save')" :disabled="isProcessing">{{ trans('Quotation::quotation.buttons.update') }}</button>
                        </div>
                    </div>
                </div>
                {{-- Quotation form end --}}
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
@endsection

@push('footerAssetPush')
<script src="{{ url('public/assets/invoice/js/vue.min.js') }}"></script>
<script src="{{ url('public/assets/invoice/js/vue-resource.min.js') }}"></script>
<script type="text/javascript">
    Vue.http.headers.common['X-CSRF-TOKEN'] = '{{csrf_token()}}';

    window._form = {!! $quotation->toJson() !!};
</script>
<script src="{{ url('public/assets/invoice/js/app.js') }}"></script>
@endpush