@extends('backend::pages.module')

@section('moduleTitle')
    <i class="fa fa-laptop"></i> {{ trans('Quotation::quotation.title') }}
@endsection
@section('moduleDescription')
    {{ trans('Quotation::quotation.optional_title.view') }}
@endsection

@section('moduleBreadcrumb')
    <li><a href="{{ route('quotation.list') }}"><i class="fa fa-laptop"></i>{{ trans('Quotation::quotation.breadcrumb.first') }}</a></li>
    <li class="active">{{ trans('Quotation::quotation.breadcrumb.second') }}</li>
@endsection


@section('moduleContent')
    <div class="col-md-12">

        @if ($errors->any())
            @foreach ($errors->all() as $error)
                <div class="alert alert-danger" >
                    {!! $error !!}
                </div>
            @endforeach
        @endif
        <!-- Box Comment -->
        <div class="box">
            <div class="box-header">
                <section class="content-header">
                    <h1 class="box-title">
                        @yield('moduleTitle', 'New Monule')
                        <small>@yield('moduleDescription', 'Optional description')</small>
                    </h1>
                </section>
                <!-- /.user-block -->
                <div class="box-tools hidden-xs">
                    @role('Admin')
                    <a href="{{ route('quotation.edit', $quotation->id) }}">
                        <button type="button" class="btn btn-flat margin-bottom pull-right bg-blue" data-toggle="tooltip" title="{{ trans('Quotation::quotation.optional_title.edit') }}">
                            <i class="fa fa-pencil"></i> {{ trans('Quotation::quotation.optional_title.edit') }}
                        </button>
                    </a>
                    @endrole
                    <button type="button" class="btn btn-flat margin-bottom bg-olive pull-right" data-toggle="modal" data-target="#sendEmail"  title="Send Email">
                        <i class="fa fa-envelope"></i> {{ trans('Quotation::quotation.buttons.send_email') }}</button>

                </div>
                <!-- /.box-tools -->
            </div><!-- /.box-header -->
            <!-- /.box-header -->
            <div class="box-body">
                <!-- Quotation content -->
                <section class="quotation">
                    <!-- title row -->
                    <div class="row">
                        <div class="col-xs-12">
                            <h2 class="page-header">
                                <i class="fa fa-globe"></i> {{ isite()->siteName() }}
                                <small class="pull-right">Date: {{ date('Y-m-d') }}</small>
                            </h2>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- info row -->
                    <div class="row quotation-info">
                        <div class="col-sm-4 quotation-col">
                            <h4>{{ trans('Quotation::quotation.view.from') }}</h4>
                            <address>
                                <strong>{{ isite()->siteName() }}</strong><br>
                                {{ $quotation->user->name }}<br>
                                {{ isite()->sitePhone() }}<br>
                                {{ isite()->siteAddress() }}<br>
                                {{ isite()->siteCity().', '.isite()->siteState().', '.isite()->siteCountry() }}<br>
                                {{ isite()->siteEmail() }}
                            </address>
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-4 quotation-col">
                            <h4>{{ trans('Quotation::quotation.view.to') }}</h4>
                            <address>
                                <strong>{{ $client->name }}</strong><br>
                                @if(isset($company->company)){{ $company->company }}<br>@endif
                                @if($company->phone){{ $company->phone }}<br>@endif
                                @if($company->address_line_one){{ $company->address_line_one. ', '. $company->address_line_two }}<br>@endif
                                @if($company->city){{ $company->city. ', '. $company->state.', '.$company->zip_code.', '.$company->country }}<br>@endif
                                {{ $client->email }}
                            </address>
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-4 quotation-col">
                            <h4>{{ trans('Quotation::quotation.view.info') }}</h4>
                            <b>{{ trans('Quotation::quotation.inputs.quotation_no') }} #{{ $quotation->serial }}</b><br>
                            <b>{{ trans('Quotation::quotation.inputs.quotation_id') }}:</b> {{ $quotation->id }}<br>
                            <br>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->

                    <!-- Table row -->
                    <div class="row">
                        <div id="hide-table">
                            <div class="col-xs-12 table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                    <tr>
                                        <th data-title="{{ trans('Quotation::quotation.table.name') }}">{{ trans('Quotation::quotation.table.name') }}</th>
                                        <th data-title="{{ trans('Quotation::quotation.table.amount') }}">{{ trans('Quotation::quotation.table.amount') }}</th>
                                        <th data-title="{{ trans('Quotation::quotation.table.quantity') }}">{{ trans('Quotation::quotation.table.quantity') }}</th>
                                        <th data-title="{{ trans('Quotation::quotation.table.subtotal') }}">{{ trans('Quotation::quotation.table.subtotal') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($quotation->products as $product)
                                        <tr>
                                            <td data-title="{{ trans('Quotation::quotation.table.name') }}" class="table-name">{{$product->name}}</td>
                                            <td  data-title="{{ trans('Quotation::quotation.table.amount') }}" class="table-price">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->price, 2)}}</td>
                                            <td  data-title="{{ trans('Quotation::quotation.table.quantity') }}" class="table-qty">{{$product->quantity}}</td>
                                            <td data-title="{{ trans('Quotation::quotation.table.subtotal') }}" class="table-total text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($product->quantity * $product->price, 2)}}</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.col -->
                    </div>
                    <div class="row">
                        <div class="col-xs-6">
                            <p class="lead">Quotation Note:</p>
                            <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                                {{ $quotation->note }}
                            </p>
                        </div>
                        <div class="col-lg-6">
                            <table class="table table-bordered">
                                <tfoot>
                                <tr>
                                    <th class="table-label">{{ trans('Quotation::quotation.table.total') }}</th>
                                    <td class="table-amount text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($quotation->sub_total, 2)}}</td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Quotation::quotation.table.discount') }}</th>
                                    <td class="table-amount text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($quotation->discount, 2)}}</td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Quotation::quotation.table.tax') }}</th>
                                    <td class="table-amount text-right">
                                        @if(isset($tax))
                                            @if($tax->type == 1)
                                                %
                                            @else
                                                {{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}
                                            @endif
                                            {{$tax->rate}}
                                        @else
                                            0.00
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th class="table-label">{{ trans('Quotation::quotation.table.grand_total') }}</th>
                                    <td class="table-amount text-right">{{ $quotation->currency->currency_symbol ? $quotation->currency->currency_symbol : isite()->siteCurrencySymbol() }}{{ number_format($quotation->grand_total, 2) }}</td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <!-- /.row -->

                    <div class="row">
                        <!-- accepted payments status -->
                        <div class="col-xs-6"></div>
                        <div class="col-xs-6" style="padding-top:40px;">
                            <a class="btn btn-primary pull-right" style="margin-right: 5px;" href="{{ route('quotation.pdf', $quotation) }}">
                                <i class="fa fa-download"></i> {{ trans('Quotation::quotation.buttons.generate_pdf') }}
                            </a>
                        </div>

                    </div>
                    <!-- /.row -->
                </section>
                <!-- Quotation section end -->
            </div>
        </div>
    </div>
    <div class="clearfix"></div>


    <div class="modal fade" id="sendEmail" role="dialog">
        <div class="modal-dialog ">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">{{ trans('Quotation::quotation.inputs.quotation_no') }} #{{$quotation->serial}}</h4>
                </div>
                {!! Form::open(['method' => 'POST','route' => ['quotation.send.email', $quotation->id], 'id' => 'sendEmailForm', 'class' => 'form-horizontal']) !!}
                <div class="modal-body">
                    <div class="form-group">
                        {!! Form::label('Email', trans('Quotation::quotation.inputs.email'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::text('email', $client->email, ['class' => 'form-control', 'id' => 'email']) !!}
                            <span class="email-error text-danger"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('subject', trans('Quotation::quotation.inputs.subject'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::text('subject', null, ['class' => 'form-control', 'id' => 'subject']) !!}
                            <span class="subject-error text-danger"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('body', trans('Quotation::quotation.inputs.message'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::textarea('body', null, ['class' => 'form-control', 'cols' => '30', 'rows' => '5', 'id' => 'subject']) !!}
                            <span class="body-error text-danger"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        {!! Form::label('attachStatus', trans('Quotation::quotation.inputs.attachStatus'), ['class' => 'col-lg-4 control-label']) !!}
                        <div class="col-lg-8">
                            {!! Form::checkbox('attachStatus', true, ['class' => 'form-control']) !!}
                            <span class="attachStatus-error text-danger"></span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans("Quotation::quotation.inputs.close") }}</button>
                    <button type="submit" class="btn btn-success" id="send-email">{{ trans("Quotation::quotation.inputs.send_email") }}</button>
                </div>
                {!!  Form::close()  !!}
            </div>

        </div>
    </div>
    <!-- /.payment history -modal -->
@endsection

@push('headerAssetPush')
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
<link rel="stylesheet" href="{{ url('bassets/plugins/datepicker/datepicker3.css') }}">
<style>
    .quotation {
        font-size: 16px;
    }
</style>
@endpush

@push('footerAssetPush')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script src="{{ url('bassets/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
<script>

    $(function(){
        $('#sendEmailForm').on('submit',function(e){
            $.ajaxSetup({
                header:$('meta[name="_token"]').attr('content')
            })
            e.preventDefault(e);

            $.ajax({

                type:"POST",
                url:'{{ route('quotation.send.email', $quotation->id) }}',
                data:$(this).serialize(),
                dataType: 'json',
                success: function(data){
                    console.log(data);
                    $('#sendEmail').modal('hide');
                    toastr.success("Success!");
                },
                error: function(data){
                    if (data.responseJSON) {
                        if (data.responseJSON.body) {
                            $('.body-error').html(data.responseJSON.body);
                        } else {
                            $('.body-error').html("");
                        }
                        if (data.responseJSON.subject) {
                            $('.subject-error').html(data.responseJSON.subject);
                        } else {
                            $('.subject-error').html("");
                        }
                        if (data.responseJSON.email) {
                            $('.email-error').html(data.responseJSON.email);
                        } else {
                            $('.email-error').html("");
                        }
                    } else {
                        $('#sendEmail').modal('hide');
                        toastr.error("Please Configure your smtp settings");
                    }
                }
            })
        });
    });

</script>
@endpush
