<?php
/*
| -------------------------------------------------------------
| AUTHOR:           INILABS TEAM
| -------------------------------------------------------------
| EMAIL:            info@inilabs.net or labs.ini@gmail.com
| -------------------------------------------------------------
| WEBSITE:          http://inilabs.net
| -------------------------------------------------------------
*/
Route::group(['Module' => 'Quotation', 'prefix' => 'admin/quotation', 'namespace' => '\Modules\Quotation\Controllers', 'middleware' => ['web', 'installer', 'auth', 'acl']], function() {

    Route::get('/', 'QuotationController@index')->name('quotation.list');
    Route::get('list', 'QuotationController@quotationDataTable')->name('quotation.list.datatable');

    Route::get('add', 'QuotationController@add')->name('quotation.create');
    Route::post('add', 'QuotationController@store')->name('quotation.create.post');

    Route::get('edit/{quotation}', 'QuotationController@edit')->name('quotation.edit');
    Route::put('edit/{quotation}', 'QuotationController@update')->name('quotation.edit.post');

    Route::delete('delete/{quotation}', 'QuotationController@delete')->name('quotation.destroy');
    Route::get('view/{id}', 'QuotationController@view')->name('quotation.view');

    Route::get('/get_tax/{tax_id}', function($tax_id)
    {
        $tax = \Modules\Tax\Models\Tax::findOrFail($tax_id);
        return response()
            ->json([
                'rate' => $tax->rate,
                'type' => $tax->type
            ], 200);
    })->name('quotation.get_tax');

    Route::post('send/{quotation}','QuotationController@sendEmail')->name('quotation.send.email');

    Route::get('pdf/{id}', 'QuotationController@quotationPdf')->name('quotation.pdf');

});
