@if ($formFor == 'create')
    {!! Form::open(['route' => ['report.post'], 'class' => 'form-horizontal']) !!}
@endif

    <div class="box-body">

        <div class="form-group{{ $errors->has('client_id') ? ' has-error' : '' }}">
            {!! Form::label('client_id', trans('Invoice::invoice.inputs.client'), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::select('client_id', ['' =>  trans('Report::report.inputs.select_client') ]+$clients,null, ['class' => 'form-control select2']) !!}
                {!! $errors->first('client_id', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('from_date') ? ' has-error' : '' }}">
            {!! Form::label('from_date', trans("Report::report.inputs.from_date"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('from_date', null, ['class' => 'form-control', 'id' => 'from_date']) !!}
                {!! $errors->first('from_date', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

        <div class="form-group{{ $errors->has('to_date') ? ' has-error' : '' }}">
            {!! Form::label('to_date', trans("Report::report.inputs.to_date"), ['class' => 'col-lg-2 control-label']) !!}
            <div class="col-lg-6">
                {!! Form::text('to_date', null, ['class' => 'form-control', 'id' => 'to_date']) !!}
                {!! $errors->first('to_date', '<span class="help-block">:message</span>') !!}
            </div>
        </div>

    </div>

    <div class="box box-info">
        <div class="box-body">
            <div class="form-group">
                <div class="col-sm-4 col-sm-offset-2">
                    {{ link_to_route('report.list', trans('Report::report.buttons.cancel'), [], ['class' => 'btn btn-danger']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary hidden-xs']) }}
                    {{ Form::submit($submitButton, ['class' => 'btn btn-primary visible-xs pull-right']) }}
                </div>
            </div>
            <div class="clearfix"></div>
        </div><!-- /.box-body -->
    </div><!--box-->
{{ Form::close() }}


@push('headerAssetPush')
<link rel="stylesheet" href="{{ url('bassets/plugins/select2/select2.min.css') }}">
<link rel="stylesheet" href="{{ url('bassets/plugins/datepicker/datepicker3.css') }}">
<style type="text/css">
    .select2-container .select2-selection--single {
        height: 34px !important;
    }
    .select2-container--default .select2-selection--single {
        border-radius: 0px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 34px !important;
    }
</style>
@endpush

@push('footerAssetPush')
<script src="{{ url('bassets/plugins/select2/select2.full.min.js') }}"></script>
<script src="{{ url('bassets/plugins/select2/select2.min.js') }}"></script>
<script src="{{ url('bassets/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
<script>
    $('.select2').select2();
    $('#from_date').datepicker({format: 'yyyy-mm-dd', autoclose: true});
    $('#to_date').datepicker({format: 'yyyy-mm-dd', autoclose: true});
</script>
@endpush